#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
# 
# If the plugin is successful, it will issue a security_hole(). Should
# it attempt to determine if the remote host is a kerberos client and
# issue a security_warning() if it's not ?
#

if(description)
{
 script_id(10802);
 
 name["english"] = "OpenSSH < 3.0.1";
 script_name(english:name["english"]);
 
 desc["english"] = "
You are running a version of OpenSSH which is older than 3.0.1.

Versions older than 3.0.1 are vulnerable to a flaw in which
an attacker may authenticate, provided that Kerberos V support
has been enabled (which is not the case by default). 
It is also vulnerable a an excessive memory clearing bug, 
believed to be unexploitable.

*** You may ignore this warning if this host is not using
*** Kerberos V

Solution : Upgrade to OpenSSH 3.0.1
Risk factor : Low (if you are not using Kerberos) or High (if kerberos is enabled)";
	
	

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the remote SSH version";
 summary["francais"] = "Vrifie la version de SSH";
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2001 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2001 Renaud Deraison");
 family["english"] = "Gain a shell remotely";
 family["francais"] = "Obtenir un shell  distance";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/ssh", 22);
 exit(0);
}

#
# The script code starts here
#


port = get_kb_item("Services/ssh");
if(!port)port = 22;

key = string("ssh/banner/", port);
banner = get_kb_item(key);


if(!banner)
{
  if(get_port_state(port))
  {
    soc = open_sock_tcp(port);
    banner = recv(socket:soc, length:1024);
    banner = tolower(banner);
    close(soc);
  }
}

if(!banner)exit(0);

b = banner - string("\r\n");


if("openssh" >< banner)
{
 if(ereg(pattern:"openssh[-_](1\..*|2\..*|3\.0[^\.])[^0-9]*", string:banner))
	security_hole(port);
}
