#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
# and was modified and tested by Vanja Hrustic <vanja@relaygroup.com>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10543);

 
 name["english"] = "Lotus Domino SMTP overflow";
 name["francais"] = "Dpassement de buffer dans le serveur SMTP Domino ";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "
The remote Domino SMTP server is vulnerable to 
a buffer overflow when supplied a too long
ENVID variable within a MAIL FROM command.

An attacker may use this flaw to prevent Domino
services from working properly, or to execute arbitrary 
code on this host.

Solution : Upgrade to Lotus Notes/Domino 5.0.6
Risk factor : High";




 desc["francais"] = "
Le serveur SMTP Domino distant est vulnrable  
un dpassement de buffer lorsqu'un utilisateur 
donne un argument trop long  la variable ENVID.

Un pirate peut utiliser ce problme pour empecher
les services domino de fonctionner, ou bien meme
executer du code arbitraire sur cette machine.

Solution : Mettez  jour votre serveur en Lotus Notes/Domino 5.0.6
Facteur de risque : Elev";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Determines if the remote Domino server is vulnerable to a buffer overflow";
 summary["francais"] = "Determines if the remote Domino server is vulnerable to a buffer overflow";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison",
		francais:"Ce script est Copyright (C) 2000 Renaud Deraison");
 family["english"] = "SMTP problems";
 family["francais"] = "Problmes SMTP";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_require_keys("www/domino");
 exit(0);
}

#
# The script code starts here
#

port = get_kb_item("Services/smtp");
if(!port)port = 25;

if(get_port_state(port))
{
  soc = open_sock_tcp(port);
  if(soc)
  {
    r = recv(socket:soc, length:4096);
    if("omino" >< r)
    {
    if(!r)exit(0);
    req = string("EHLO nessus.org\r\n");
    send(socket:soc, data:req);
    r  = recv(socket:soc, length:4096);

    req = string("MAIL FROM: <nessus@nessus.org> ENVID=", crap(300), "\r\n");
    send(socket:soc, data:req);
    r = recv(socket:soc, length:4096);

    if(ereg(pattern:"^250 ", string:r))
        security_hole(port);
    }
    close(soc);
   }
}
