/********************************************************************************
 *                              Nepenthes
 *                        - finest collection -
 *
 *
 *
 * Copyright (C) 2005  Paul Baecher & Markus Koetter
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * 
 *             contact nepenthesdev@users.sourceforge.net  
 *
 *******************************************************************************/

 /* $Id: sch_generic_connect_trans.cpp 341 2006-02-20 09:51:00Z common $ */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "LogManager.hpp"
#include "Message.hpp"
#include "sch_generic_connect_trans.hpp"
#include "Socket.hpp"
#include "Nepenthes.hpp"
#include "Utilities.hpp"
#include "DialogueFactoryManager.hpp"
#include "SocketManager.hpp"
#include "DialogueFactory.hpp"
#include "DownloadManager.hpp"

#include "Config.hpp"
#include "shellcode-generic.hpp"



#ifdef STDTAGS 
#undef STDTAGS 
#endif
#define STDTAGS l_sc | l_hlr

using namespace nepenthes;

GenericConnectTrans::GenericConnectTrans(ShellcodeManager *shellcodemanager)
{
	m_ShellcodeManager = shellcodemanager;
	m_ShellcodeHandlerName = "GenericConnectTrans";
	m_ShellcodeHandlerDescription = "various csends";
	
}

GenericConnectTrans::~GenericConnectTrans()
{

}

bool GenericConnectTrans::Init()
{
	logPF();

	StringList sList;
	try
	{
		sList = *g_GenericShellcodeHandler->getConfig()->getValStringList("shellcode-generic.generic_connect_trans");
	} catch ( ... )
	{
		logCrit("%s","Error setting needed vars, check your config\n");
		return false;
	}

	uint32_t i = 0;
	while (i < sList.size())
	{
		const char *name = sList[i];
		i++;

		const char *pattern = sList[i];
		i++;

		uint16_t offset = atoi(sList[i]);
		i++;

//		logInfo("pcre is %s \n",pattern);
		const char * pcreEerror;
		int32_t pcreErrorPos;
		pcre *mypcre=NULL;
		if((mypcre = pcre_compile(pattern, PCRE_DOTALL, &pcreEerror, (int *)&pcreErrorPos, 0)) == NULL)
		{
			logCrit("GenericConnectTrans could not compile pattern \n\t\"%s\"\n\t Error:\"%s\" at Position %u", 
					pattern, pcreEerror, pcreErrorPos);
			return false;
		}else
		{
			logDebug("Adding %s \n",name);
			PcreContext *ctx = new PcreContext;
			ctx->m_Name = name;
			ctx->m_Pcre = mypcre;
			ctx->m_Offset = offset;
			m_Pcres.push_back(ctx);
		}
	}
	return true;
}

bool GenericConnectTrans::Exit()
{
	logPF();
	while(m_Pcres.size() > 0)
	{
		pcre_free(m_Pcres.front()->m_Pcre);
		delete m_Pcres.front();
		m_Pcres.pop_front();
	}
	return true;
}

sch_result GenericConnectTrans::handleShellcode(Message **msg)
{
	logPF();
	logSpam("Shellcode is %i bytes long \n",(*msg)->getSize());
	char *shellcode = (*msg)->getMsg();
	uint32_t len = (*msg)->getSize();

	int32_t output[10 * 3];


	list <PcreContext *>::iterator it;
	uint32_t i;
	for ( it=m_Pcres.begin(), i=0; it != m_Pcres.end();it++,i++ )
	{
		int32_t result=0;
		const char *match;
		if ( (result = pcre_exec((*it)->m_Pcre, 0, (char *) shellcode, len, 0, 0, (int*)output, sizeof(output)/sizeof(int32_t))) > 0 )
		{
			uint32_t host = 0, codesizeLen;
			uint16_t port=0;

			codesizeLen = pcre_get_substring((char *) shellcode, (int *)output, (int)result, 1, &match);
			if( codesizeLen == 2 )
			{
            	port = (uint32_t)*((uint16_t *)match);
				port = ntohs(port);
			}else
			if( codesizeLen == 4 )
			{
				host = (uint32_t)*((uint32_t *)match);
			}

			pcre_free_substring(match);

			codesizeLen = pcre_get_substring((char *) shellcode, (int *)output, (int)result, 2, &match);
			if( codesizeLen == 2 )
			{
				port = (uint32_t)*((uint16_t *)match);
				port = ntohs(port);
			}else
			if( codesizeLen == 4 )
			{
				host = (uint32_t)*((uint32_t *)match);
			}
			pcre_free_substring(match);


			logInfo("Detected connectbacktransfer shellcode %s, %s:%u  \n",(*it)->m_Name.c_str(), inet_ntoa(*(in_addr *)&host), port);


			char *url;
			asprintf(&url,"csend://%s:%d/%i",inet_ntoa(*(in_addr *)&host), port, (*it)->m_Offset);
			g_Nepenthes->getDownloadMgr()->downloadUrl((*msg)->getLocalHost(),url, (*msg)->getRemoteHost(), url,0);
			free(url);

			return SCH_DONE;

		}
	}
	return SCH_NOTHING;
}


