using Nemerle.Collections.List;
using Nemerle.Utility;
using Nemerle.Utility.NString;
using System;
using SC=System.Console;
using System.Reflection;
using System.Text.RegularExpressions.Regex;
  
namespace Nemerle.Evaluation.Interpreter
{
  /**
   * Holds properties, variables and functions for use within
   * the interpreter (by the user) and in the interpreters
   * main loop.
   */
  public module Internals
  {
    public nccversion : Version = Reflection.Assembly.GetAssembly 
                                  (typeof (Nemerle.Compiler.MainParser)).
                                  GetName ().Version;
    internal interpassembly : string = Reflection.Assembly.GetAssembly
                                       (typeof (Internals)).Location;

    // The primary prompt.
    [Accessor (PS1, flags = WantSetter)]
    mutable ps1 : string = "- "; 

    // The secondary prompt displayed for multiple line input.
    [Accessor (PS2, flags = WantSetter)]
    mutable ps2 : string = "= "; 
    
    // The current prompt.
    [Accessor (flags = WantSetter)]
    mutable prompt : string = ps1; 
  
    public Ref : string {
      get { 
        FoldLeft (Tl (Evaluator.refr), "", fun (x, acc) { x + ", " + acc }).
                 TrimEnd (array [',', ' ']) 
      }
      set { 
        Evaluator.refr = interpassembly :: 
                         Split (Replace (value, @"\s", ""), [','])
      }
    }
  
    public Help : void {
      get { 
        SC.WriteLine ("Help\t-\tPrint this help.");
        SC.WriteLine ("Ref\t-\tLink specified assemblies.\n\t\tex. Ref = "
                      "\"Nemerle.dll, Nemerle.Compiler.dll\"");
        SC.WriteLine ("PS1\t-\tSet primary prompt.\n\t\tex. PS1 = \">>> \"");
        SC.WriteLine ("PS2\t-\tSet secondary prompt.\n\t\tex. PS2 = \"... \"");
        SC.WriteLine ("\nNote: All these properties reside in the\n"
                      "      Nemerle.Evaluation.Interpreter.Internals\n"
                      "      namespace, which is open when using the default\n"
                      "      ~/.nemerlish_profile file.");
        SC.WriteLine ("\nYou can also invoke a command in a subshell with "
                      "\"!command;;\",\nor simply type \"!;;\" to run the "
                      "default shell.\n");
        SC.WriteLine ("\nTyping '**' after a piece of code will show all\n"
                      "available possibilities to complete.\n"
                      "\tex.A**\n");
        SC.WriteLine ("Use ^c (ctrl-c) to quit.\n")
      }
    }
  }
}
