// Copyright (c) 2003-2005 The University of Wroclaw.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
//    1. Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//    2. Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//    3. The name of the University may not be used to endorse or promote
//       products derived from this software without specific prior
//       written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
// NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
// TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

namespace Nemerle.CSharp
{
    public class ErrorException : System.Exception
    {
	public this ()
	{}
    }
    
    public class Message
    {		
	/* ------------------------------------------------- */
	/* -- writes error msg to the screen, doesn't quit-- */
	 
	public static Error (msg : string, line : int, col : int ) : void
	{
	    mutable m = line.ToString () + ":" + col.ToString () + ":";
	    
	    write (Some (m), msg , "error");
	}	

	public static Error (msg : string, t : antlr.IToken ) : void
	{
	    Error (msg , t.getLine () ,t.getColumn ());
	}

	public static Error (msg : string) : void 
	{ 
	    write (None (),msg, "error");
	}

	/* ----------------------------------- */
	/* -- writes warnings to the screen -- */

	public static Warning (msg : string, line : int, col : int ) : void
	{
	    mutable m = line.ToString () + ":" + col.ToString () + ":";
	    
	    write (Some (m), msg , "warning");
	}

	public static Warning (msg : string, t : antlr.IToken ) : void
	{
	    Warning (msg , t.getLine () ,t.getColumn ());
	}

	public static Warning (msg : string) : void 
	{ 
	    write (None (), msg, "warning");
	}

	/* ------------------------------------------------------ */
	/* -- main function for writing messages to the screen -- */

	private static write (loc : option[string],msg : string , kind : string ) : void
	{
	    mutable m = in_file + ":" + 
	    match (loc)
	    {
		| None => " "
		| Some (loc) => loc + " " ;
	    }

	    match (Options.ColorMessages)
	    {
		| true => 
		    match(kind)
		    {
			| "error" => 
			    m += "\e[01;31merror\e[0m:";
			    error = true;	
			| "warning" => m += "\e[01;33mwarning\e[0m:"
			| _ => m += kind + ":"
		    }
		| _ => 
		    m += kind + ":";
		    when (kind == "error")
			error = true;
	    }

	    System.Console.Error.WriteLine ( m + " " + msg );	    
	}

	public static WasError : bool
	{
	    get
	    {
		error
	    }
	}

	public static InFile : string
	{
	    set
	    {
		in_file = value;	
	    }
	}	

	public static mutable error : bool = false;
	public static mutable in_file : string;
    }
}
