/*
 * Copyright (c) 2003, 2004 The University of Wroclaw.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *    3. The name of the University may not be used to endorse or promote
 *       products derived from this software without specific prior
 *       written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE UNIVERSITY BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

using Sioux;
using Nemerle.Collections;
using Nemerle.Xml;
using System.Xml;
using System;

namespace Sioux.RequestParameters
{
    public class RequestParameters : Application
    {
        public this ()
        {
            names = "No parameters in this request<br/>"
        }
        
        protected override DoGet() : void
        {
            def doc = XmlDocument ();
            def sb = System.Text.StringBuilder();
            ignore(sb.Append("[html][head][title]Request parameters</title></head>[body][b]Request parameters example</b><br/>"));
            ignore(sb.Append("Parameters in this request:<br/>"));

            ignore(sb.Append(names + "<br/>"));

            ignore(sb.Append("<form action=\"sendnames.xml\" method=\"POST\">"));
            ignore(sb.Append("First name:  <input type=\"text\" length=\"20\" name=\"fname\" /><br/>"));
            ignore(sb.Append("Last name:  <input type=\"text\" length=\"20\" name=\"sname\" /><br/>"));
            ignore(sb.Append("<input type=\"submit\" /></form>"));
            ignore(sb.Append("</body></html>"));

            doc.LoadXml(sb.ToString());
            
            FormTemplate = Some(XmlTemplate(doc));
        }

        protected override DoPost() : void
        {
            when(PageName == "/sendnames.xml")
            {    
                match( (PostVars.Get("fname"),PostVars.Get("sname") ))
                {
                    | (Some(fname),Some(sname)) =>
                      {
                          names = "First name: " + fname + "<br/>Last name: " + sname + "<br/>"
                      }
                    | _ => names = "No parameters in this request<br/>"
                }
            }
            DoGet()
        }

        private mutable names : string;
        
    }
}