using System;
using System.Xml;
using System.IO;
using System.Net.Sockets;
using Nemerle.Collections;

namespace Chat
{
    public class CMain
    {
        public static Main(args : array[string]) : void
        {
            if(args.Length > 0 && args[0]=="--help")
            {
                Console.WriteLine("usage: server.exe [options] PORT");
                Console.WriteLine("options:");
                Console.WriteLine("\t--help - displays this message\n");
                Console.WriteLine("parameters:");
                Console.WriteLine("\tPORT   - number of port used to communicate (default - 3000)\n");
            }
            else
            {
                if(args.Length > 0)
                {
                    def daemon = chatd(int.Parse(args[0]));
                    daemon.Run();
                }
                else
                {
                    def daemon = chatd(3000);
                    daemon.Run();
                }
            }
        }
    }
}