using System;
using System.Collections;

namespace POP3Client
{
  public class Message : MailHeader
  {
    protected mutable attachments : ArrayList;


    public this (message : string)
    {
      base (message);
      
      attachments = ArrayList ();
    
      ParseMessage ();
    }


    private ParseMessage () : void
    {
      mutable part = (null : string);

      match (contentType.Type)
      {
        | Types.MULTIPART =>
          do
          {
            part = CutToBoundary ();

            if (part != null) ignore (attachments.Add (Attachment (part))) else {};
          }
          while (part != null);
        | _ => {};
      };
    }
    
    
    private CutToBoundary () : string
    {
      mutable result = String.Empty;
      mutable lines  = 0;

      while (!message[0].StartsWith (boundary)) message.RemoveAt (0);
      message.RemoveAt (0);

      while (message.Count != 0 && !message[0].StartsWith (boundary))
      {
        result = result +  "\r\n" + message[0];
        message.RemoveAt (0);
        lines = lines + 1;
      };

      if (lines > 2) result else null;
    }
    
    
    public GetAttachment (index : int) : array [byte]
    {
      (attachments[index] :> Attachment).Data;
    }
  }
}
