using System;
using System.Collections;
using System.Collections.Specialized;
using System.Drawing;
using System.Threading;
using System.Xml;

using POP3Client;

namespace EraSMSSender
{
  public class EraAccount
  {
    protected mutable mail     : string;
    protected mutable password : string;
    protected mutable image    : Image;
    protected mutable date     : DateTime;
    protected mutable limit    : int;

    protected mutable era               : EraHTTP;
    protected mutable recognitionResult : bool;


    public this (mail : string, image : Image)
    {
      this.mail  = mail;
      this.image = image;
      
      password          = String.Empty;
      limit             = 0;
      recognitionResult = false;
    }


    public Recognized : bool
    {
      get { recognitionResult }
    }


    public PasswordImage : Image
    {
      get { image }
    }


    public Limit : int
    {
      get { limit }
      set { limit = value }
    }
    

    public RecognizedPassword : string
    {
      get { password }
      set { password = value }
    }


    public Test () : bool
    {
      if (password.Length == 0) false
      else
      {
        era = EraHTTP (mail, password);

        try
        {
          limit             = era.GetLimit ();
          recognitionResult = true;
          
          true;
        }
        catch 
        {
          | _e is EraHTTPException => false;
        }
      }
    }


    public SMSEngine : EraHTTP
    {
      get { era }
    }
  }
  

//  delegate StatusDelegate: string -> void;
  

  public class AccountItem : Informer
  {
    protected mutable mail     : string;
    protected mutable password : string;
    protected mutable server   : string;
    protected mutable thread   : Thread;

    protected mutable lastEngine : EraAccount;
    protected mutable connection : POP3EraClient;

    protected mutable status         : string;
    protected mutable passwordsArray : ArrayList;

    public event ChangeStatus : EventHandler;


    public this (mail : string, password : string, server : string)
    {
      if (mail == null || password == null || server == null) throw ArgumentException ()
      else
      {
        this.mail     = mail;
        this.password = password;
        this.server   = server;

        connection          = POP3EraClient (server, mail, password);
        connection.Informer = this;
        lastEngine          = null;
        thread              = null;
        status              = String.Empty;
        passwordsArray      = ArrayList ();
        
        ChangeStatus        = null;
      }
    }


    public Inform (information : object, _e : EventArgs) : void
    {
      if (ChangeStatus != null) ChangeStatus (information, null) else {};
    }


    public Actualize () : void
    {
      Inform ("Liczba hasel: " + Count.ToString () + ", rozpoznanych: " + Recognized.ToString ()
        + ", limit: " + Limit.ToString (), null);
    }
    

    public Check () : void
    {
      thread = Thread (ThreadStart (Checker));

      thread.Start ();
      thread.Name = "Mailchecker on " + server + " for " + mail + "@" + server;
    }
    

    public Order () : void
    {
      thread = Thread (ThreadStart (Orderer));

      thread.Start ();
      thread.Name = "Ordering password for " + mail + "@" + server;
    }
    
    private Orderer () : void
    {
      try
      {
        mutable era = EraHTTP (mail + "@" + server, "");

        Inform ("Wysylanie zadania...", null);
        
        era.Order ();

        Actualize ();
      }
      catch
      {
        | e is EraHTTPException => Inform ("Error: " + e.Message, null);
        | e         => Inform ("Error: " + e.Message, null);
      };

      thread = null;
    }
    

    private Checker () : void
    {
      try
      {
        connection.Connect ();

        mutable array_ = connection.GetTodayEraImages ();

        passwordsArray.Clear ();
        
        foreach (entry :> DictionaryEntry in array_)
        {
          ignore (passwordsArray.Add (EraAccount (((entry.Key :> Person).Email, (entry.Value :> Image)))));
        };

        thread = null;
        Actualize ();
      }
      catch
      {
        | e is EraHTTPException => Inform ("Error: " + e.Message, null);
        | e         => Inform ("Error: " + e.Message, null);
            Console.WriteLine (e.StackTrace);
      };

      thread = null;
      connection.Close ();

    }
    

    public GetXmlNode (doc : XmlDocument) : XmlNode
    {
      mutable node = doc.CreateNode (XmlNodeType.Element, "Account", null);
      mutable ele  = (null : XmlNode);
            
      ele = doc.CreateElement ("Login");
      ignore (ele.AppendChild (doc.CreateTextNode (Mail)));
      ignore (node.AppendChild (ele));

      ele = doc.CreateElement ("Server");
      ignore (ele.AppendChild (doc.CreateTextNode (Server)));
      ignore (node.AppendChild (ele));

      ele = doc.CreateElement ("Password");
      ignore (ele.AppendChild (doc.CreateTextNode (Password)));
      ignore (node.AppendChild (ele));

      //      ele = doc.CreateElement ("Date");
      //      ele.AppendChild (doc.CreateTextNode (

      node;
    }
    

    public GetEngine () : EraHTTP
    {
      mutable result = (null : EraHTTP);
    
      foreach (account :> EraAccount in passwordsArray)
      {
        if (account.Limit > 0)
        {
          lastEngine = account;

          result = account.SMSEngine;
        }
        else {};
      };

      result;
    }
    

    public Sent : int
    {
      set
      {
        if (lastEngine != null)
        {
          lastEngine.Limit = lastEngine.Limit - value;
          lastEngine       = null;
        }
        else {};
      }
    }
    

    public Mail : string
    {
      get { mail }
      set
      {
        mail            = value;
        connection.User = value;
      }
    }


    public Password : string
    {
      get { password }
      set
      {
        password            = value;
        connection.Password = value;
      }
    }


    public Server : string
    {
      get { server }
      set
      {
        server            = value;
        connection.Server = value;
      }
    }


    public Status : string
    {
      get { String.Empty }
    }


    public Unrecognized : int
    {
      get
      {
        mutable result = 0;

        foreach (account :> EraAccount in passwordsArray)
        {
          if (!account.Recognized) result = result + 1 else {};
        };

        result;
      }
    }


    public Recognized : int
    {
      get { Count - Unrecognized }
    }


    public Next (index : int) : int
    {
      mutable result = -1;
    
      for (mutable i = index + 1; i < passwordsArray.Count; i = i + 1)
      {
        if (!Get (i).Recognized)
        {
          result = i;
          i      = passwordsArray.Count;
        }
        else {};
      };

      result;
    }


    public Prev (index : int) : int
    {
      mutable result = -1;
    
      for (mutable i = index - 1; i >= 0; i = i - 1)
      {
        if (!Get (i).Recognized)
        {
          result = i;
          i      = -1;
        }
        else {};
      };

      result;
    }
    

    public Get (index : int) : EraAccount
    {
      (passwordsArray[index] :> EraAccount);
    }


    public Count : int
    {
      get { passwordsArray.Count }
    }


    public Connected : bool
    {
      get { thread != null }
    }


    public Limit : int
    {
      get
      {
        mutable result = 0;

        foreach (account :> EraAccount in passwordsArray)
        {
          result = result + account.Limit;
        };

        result;
      }
    }
  }
  

  public class AccountDatabaseEnumerator : IEnumerator
  {
    mutable position : int;
    mutable database : AccountDatabase;


    public this (database : AccountDatabase)
    {
      if (database == null) throw ArgumentException ()
      else
      {
        this.database = database;
        this.position = -1;
      }
    }

    
    public Reset () : void
    {
      position = -1;
    }


    public MoveNext () : bool
    {
      if (position + 1 < database.Count)
      {
        position = position + 1;
        true;
      }
      else false;
    }


    public Current : object
    {
      get { database.Get (position) }
    }
  }
  

  public class AccountDatabase : IEnumerable
  {
    protected mutable lastEngine : AccountItem;
    protected mutable fileName   : string;
    protected mutable items      : ArrayList;


    public this ()
    {
      lastEngine = null;
      items      = ArrayList ();
      fileName   = "accounts.xml";
    }


    public Add (item : AccountItem) : void
    {
      if (item == null) throw ArgumentException ()
      else
      {
        ignore (items.Add (item));
        item.Check ();
      }
    }


    public GetEnumerator () : IEnumerator
    {
      AccountDatabaseEnumerator (this);
    }


    public Count : int
    {
      get { items.Count }
    }


    public GetEngine () : EraHTTP
    {
      mutable result = (null : EraHTTP);
    
      foreach (item :> AccountItem in items)
      {
        if (item.Limit > 0)
        {
          lastEngine = item;

          result = item.GetEngine ();
        }
        else {};
      };
  
      result;
    }

    
    public Sent : int
    {
      set
      {
        if (lastEngine != null)
        {
          lastEngine.Sent = value;
          lastEngine.Actualize ();
          lastEngine      = null;
        }
        else {};
      }
    }
    

    public Engines : int
    {
      get
      {
        mutable result = 0;

        foreach (item :> AccountItem in items)
        {
          result = result + item.Limit;
        };

        result;
      }
    }
    

    public Get (position : int) : AccountItem
    {
      (items[position] :> AccountItem); 
    }


    public Get (login : string, server : string) : AccountItem
    {
      mutable result = (null : AccountItem);
    
      foreach (item :> AccountItem in this)
      {
        if (item.Mail.Equals (login) && item.Server.Equals (server)) result = item else {};
      };

      result;
    }


    public Remove (login : string, server : string) : void
    {
      items.Remove (Get (login, server));
    }
    

    public Load () : void
    {
      try
      {
        mutable read = XmlTextReader (fileName);
        mutable doc  = XmlDocument ();
        
        doc.Load (fileName);

        mutable root = doc.DocumentElement;

        if (root.HasChildNodes && root.Name.Equals ("AccountDatabase"))
        {
          foreach (node :> XmlNode in root.ChildNodes)
          {
            if (node.Name.Equals ("Account") && node.HasChildNodes)
            {
              mutable mail     = null : string;
              mutable password = null : string;
              mutable server   = null : string;

              foreach (inner :> XmlNode in node.ChildNodes)
              {
                match (inner.Name)
                {
                  | "Login"    => if (inner.HasChildNodes) mail    = inner.FirstChild.Value else {};
                  | "Password" => if (inner.HasChildNodes) password = inner.FirstChild.Value else {};
                  | "Server"   => if (inner.HasChildNodes) server   = inner.FirstChild.Value else {};
                  | _          => {};
                };
              };

              if (mail != null && password != null && server != null) Add (AccountItem (mail, password, server)) else {};
            }
            else {};
          }
        }
        else {};

        read.Close ();
      }
      catch
      {
        | _e => {};
      }
    }


    public Save () : void
    {
      mutable wri  = XmlTextWriter (fileName, System.Text.Encoding.ASCII);
      mutable doc  = XmlDocument ();
      mutable root = doc.CreateElement ("AccountDatabase");

      wri.Formatting = Formatting.Indented;

      ignore (doc.AppendChild (doc.CreateXmlDeclaration ("1.0", null, null)));
      
      foreach (item :> AccountItem in items)
      {
        ignore (root.AppendChild (item.GetXmlNode (doc)));
      };

      ignore (doc.AppendChild (root));

      doc.WriteTo (wri);
      wri.Close ();
    }
  }
}
