using Nemerle.IO;
using Nemerle.Concurrency;

namespace Test 
{
    class Buffer [T]
    {
        [ChordMember]
        public Put (msg : T) : void;

        public Get () : T
        chord {
          | Put => msg
        }
    }

    module Main
    {
        Main () : void
        {
            def b = Buffer ();
            b.Put ("msg 1");
            b.Put ("msg 2");
            b.Put ("msg 3");
            printf ("%s\n", b.Get ());
            printf ("%s\n", b.Get ());
            printf ("%s\n", b.Get ());

            for (mutable j = 0; j < 3; ++j)
            async 
            {
                for (mutable i = 0; i < 5; ++i)
                {
                    def m = "msg " + i.ToString () + " from " + ThreadId ().ToString ();
                    b.Put (m);
                    Sleep (i * 200)
                }
            }

            async 
            {
                for (mutable i = 0; i < 15; ++i)
                {
                    printf ("%s\n", b.Get ());
                }
            }
        }
    
        Sleep (ms : int) : void
        {
            when (ms > 0) System.Threading.Thread.Sleep (ms)
        }

        ThreadId () : int
        {
            System.Threading.Thread.CurrentThread.GetHashCode ()
        }
    }
}
