using Nemerle.IO;

class B {}
class BD : B {}

class TestRefEq {

  static foo2 (x : ref B) : void { 
    x = B ();
  }

  public static Run () : void {
    mutable x = BD();
    print ("$x\n");
    foo2 (ref x);
    print ("$x\n");
  }
}
                

struct MonoEnumInfo {
         mutable val : int;

         stuff() : void { val = 1; }

        static GetInfo ( info : out MonoEnumInfo) : void {
                info.stuff();
                assert (info.val == 1);

        }

        public static Run() : void
        {

            mutable m = MonoEnumInfo ();
            GetInfo (out m);
            assert (m.val == 1);

        }
}


module A {

  g (x : ref int) : void
  {
    x *= 7;
  }

  f (x : ref int, y : out object) : void
  {
    x = x + 3;
    g (ref x);
    y = 42;
  }

  Main () : void
  {
    mutable x = 3;
    mutable y = null;
    f (ref x, out y);
    printf ("%d %s\n", x, y.ToString ());
    MonoEnumInfo.Run ();
    TestRefEq.Run ();
  }
}

/*
BEGIN-OUTPUT
42 42
BD
B
END-OUTPUT
*/
