
class Increment
{
  Item [x : uint] : uint {
    get { x }
  }

  public static Run() : void
  {
    mutable x : uint = 1;

    x = 1;
    System.Console.Write("Val: {0}", {x++; x});
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Val: {0}", {++x; x});
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Add: {0}", {x++; x} + {x++; x});
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Add: {0}", {++x; x} + {++x; x});
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Add: {0}", Add({x++; x}, {x++; x}));
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Add: {0}", Add({++x; x}, {++x; x}));
    System.Console.WriteLine(", End: {0}", x);

    x = 1;
    System.Console.Write("Add: {0}", Increment() [{++x; x} + {++x; x}]);
    System.Console.WriteLine(", End: {0}", x);
  }

  static Add(a : uint, b : uint) : uint
  {
    a + b;
  }
}

Increment.Run();


/*
BEGIN-OUTPUT
Val: 2, End: 2
Val: 2, End: 2
Add: 5, End: 3
Add: 5, End: 3
Add: 5, End: 3
Add: 5, End: 3
Add: 5, End: 3
END-OUTPUT
*/
