// OPTIONS: -r:extension-methods-lib.dll
#pragma indent
using System.Console
using Nemerle.Collections
using Nemerle.Utility
using SomeDeepNamespace
using N1

namespace N1
{
    public static class E
    {
        public static F(this _obj : object, _i : int) : void {  System.Console.WriteLine ("E.F(obj,int)") }
        public static F(this _obj : object, _s : string) : void { System.Console.WriteLine ("E.F(obj,string)") }
    }
}

namespace N2 {
class Ax { }
class Bx
{
    public F(_i : int) : void { System.Console.WriteLine ("B.F(int)") }
}
class Cx
{
    public F(_obj : object) : void { System.Console.WriteLine ("C.F(obj)") }
}
class X
{
 public static xMain () : void {
   Test (Ax(), Bx(), Cx());
 }
 
    static Test(a : Ax, b : Bx, c : Cx) : void {
        a.F(1);             // E.F(object, int)
        a.F("hello");       // E.F(object, string)
        b.F(1);             // B.F(int)
        b.F("hello");       // E.F(object, string)
        c.F(1);             // C.F(object)
        c.F("hello");       // C.F(object)
    }
}
}

module Extensions
    public All [T] (this objs : System.Collections.Generic.IEnumerable[T], fn : T -> bool) : bool
        return :
            foreach (o in objs)
                when (!fn (o))
                    return (false)
            return (true)

def ls = $ [0, 2 .. 10] : System.Collections.Generic.IEnumerable [int]

when (ls.All (x => x % 2 == 0)) 
    WriteLine ("All : even")

B.Run ()
def a = A (42)
a.foo ()
a.foo (1)
B.foo (a, 2)

def g = G.[int,string]()
g.Describe ()
g.bar ()
g.bar (7.0)

def a = array [3, 14, 15]
a.Rev ()
System.Console.WriteLine (List.FromArray (a))
B.Rev (a)
System.Console.WriteLine (a.ToList2 ())
System.Console.WriteLine (a.ToList ())
a.Iter (fun (x) { WriteLine (x) })
WriteLine ("gppcbs".Map (fun (c:char) { ((c :> int) - 1) :> char }))

N2.X.xMain ()

def a = array [1,2,3];
System.Console.WriteLine (a.Where(_ > 1));
def a = array ["foo", "bar", "foox"];
System.Console.WriteLine (a.Where(_.StartsWith ("fo")));
System.Console.WriteLine (a.NoWhere(_.StartsWith ("fo")));

/*
BEGIN-OUTPUT
All : even
foo()
foo(42,1)
foo(42,2)
foo(77,3)
foo(77,4)
System.Int32 System.String
System.Int32 System.String
System.Int32 System.String
System.Double
[15, 14, 3]
[3, 14, 15]
[2, 3]
[foo, foox]
[bar]
foo()
foo(42,1)
foo(42,2)
System.Int32 System.String
System.Int32 System.String
System.Int32 System.String
System.Double
[15, 14, 3]
[3, 14, 15]
[3, 14, 15]
3
14
15
foobar
E.F(obj,int)
E.F(obj,string)
B.F(int)
E.F(obj,string)
C.F(obj)
C.F(obj)
[2, 3]
[foo, foox]
[bar]
END-OUTPUT
*/
