// Some interfaces, one is a superset of the other  
public interface Node  
{  
     GetStat() : int;  
}  
public interface FileNode : Node  
{  
     NotUsed() : int;  
}  
  
// Some basic implementations, one is a superset of the other  
public class GenericNode : Node  
{  
    public virtual GetStat() :  int {  0; }  
}  
  
public class GenericFileNode : GenericNode , FileNode  
{  
    public virtual NotUsed() :  int {  -1; }  
}  
  
  
// Now the ability to override a method depends on if we specify again that we  
// implement an interface -- although we must because we derive from a class  
// that does.  
public class WorkingTest : GenericFileNode , FileNode  
{  
    public override GetStat() :  int {  42; }  
}  
  
public class FailingTest : GenericFileNode  
{  
    // This never gets called, but it builds, so what did we override?!!! 
    public override GetStat() :  int {  42; }  
}  
  
public class TestWrapper  
{  
    static Test(mutable  inst : Node,mutable  name :  string) :  bool  
    {  
        if(inst.GetStat() == 42)  
        {  
        {  
            System.Console.WriteLine("{0} -- Passed", name);  
             true;  
        }  
        } else {  
        {  
            System.Console.WriteLine("{0} -- FAILED", name);  
             false;  
        } }  
    }  
  
    public static Main() :  int  
    {  
        if( Test( WorkingTest(), "WorkingTest")  
                && Test( FailingTest(), "FailingTest") )  
        {  
             0;  
        } // everything worked  
        else // everything worked  
        {  
             1; // everything worked  
        }  
    }  
}
/*
BEGIN-OUTPUT
WorkingTest -- Passed
FailingTest -- Passed
END-OUTPUT
*/
