//
// Tests that explicit and normal implementations of methods are handled
// properly.  Before we used to have the normal method implementation
// "implement" the classes, so that it would go into an infinite loop.
// (bug #26334)
//
// Now explicit implementations are defined first.
//
using System;

public interface IDiagnostic
{
	 Stop() : void;
} 
public interface IAutomobile
{
	 Stop() : void;
}

public class MyCar: IAutomobile, IDiagnostic {
	public  mutable  diag_stop : bool;
	public  mutable  car_stop : bool;
	public  mutable  auto_stop : bool;
	
	 IDiagnostic_Stop() : void implements IDiagnostic.Stop {
		diag_stop = true;
	}

	public Stop() :  void {
		car_stop = true;
		mutable  self = (this :> IAutomobile); // cast this
		self.Stop(); // forwarding call
	}

	 IAutomobile_Stop() : void implements IAutomobile.Stop
	{
		auto_stop = true;
	}
}

class TestConflict {
	static Main () :  int
	{
		mutable  car1 =  MyCar();
		car1.Stop(); // calls the IAutomobile.Stop implementation
		
		mutable  car2 =  MyCar();
		car2.Stop();
		
		mutable  car3 =  MyCar();
		car3.Stop();

		if (!car1.car_stop)

		{
			 1;

		}

		else
	{

		if (car1.diag_stop)

		{
			 2;

		}

		else
	{

		Console.WriteLine ("ok");
		 0;
	}
	}
	}
}
/*
BEGIN-OUTPUT
ok
END-OUTPUT
*/
