using Nemerle.Diagnostics;

variant A {
  | X
  | Y
  | Z
}

module Test {
  test_tuple (a : A, b : A) : int
  {
    match ((a, b)) {
      | (X, Y) => 1
      | _ => 0
    }
  }
  
  test_no_tuple (a : A, b : A) : int
  {
    match (a) {
      | X =>
        match (b) {
          | Y => 1
          | _ => 0
        }
      | _ => 0
    }
  }

  run_test (times : int) : void
  {
    mutable res = 0;
    
    for (mutable i = 0; i < times; i++)
      res += test_tuple (if (i % 3 == 0) A.X () else A.Z (),
                         if (i % 4 == 0) A.Y () else A.Z ());
    
    System.Console.WriteLine (res);
  } 
  
  run_no_test (times : int) : void
  {
    mutable res = 0;
    
    for (mutable i = 0; i < times; i++)
      res += test_no_tuple (if (i % 3 == 0) A.X () else A.Z (),
                         if (i % 4 == 0) A.Y () else A.Z ());
    
    System.Console.WriteLine (res);
  } 
  
  Main () : void {
    time run_test (10000000);
    time run_no_test (10000000);
  }
}

