#!/usr/bin/perl
# Compare two Nemerle-generated IL files, generated by Portable.NET's ildasm

my $tmp = "$ENV{HOME}/tmp";

sub work
{
  my $in = shift;
  my $out = shift;
  if ($in =~ /\.exe$/i || $in =~ /\.dll$/i) {
    system("ildasm $in > $tmp/il-diff.tmp");
    $in = "$tmp/il-diff.tmp";
  }
  
  open(IN,"<$in") or die("cannot open $in");
  open(OUT,">$out");

  while (<IN>) {
	s/\?L[0-9a-f]+/L/g;
	s/(_N_[0-9A-Za-z_.]*?)[0-9]+([\s:\)])/$1$2/g;
	s/header: [0-9a-f]+//g;
	s/\.stage[0123]//g;
	s/stage[0123]//g;
	print OUT $_;
  }
}

work($ARGV[0], "$tmp/il-diff.1");
work($ARGV[1], "$tmp/il-diff.2");
system("diff -u $tmp/il-diff.1 $tmp/il-diff.2");
