#!/usr/bin/perl -w
#
# macros.pl   produce macros.c from standard.mac
#
# The Netwide Assembler is copyright (C) 1996 Simon Tatham and
# Julian Hall. All rights reserved. The software is
# redistributable under the license given in the file "LICENSE"
# distributed in the NASM archive.

use strict;

my $fname;
my $line = 0;
my $index      = 0;
my $tasm_count;

undef $tasm_count;

open(OUTPUT,">macros.c") or die "unable to open macros.c\n";

print OUTPUT "/*\n";
print OUTPUT " * Do not edit - this file auto-generated by macros.pl from:\n";
print OUTPUT " * ", join(' ', @ARGV), "\n";
print OUTPUT " */\n";
print OUTPUT "\n";
print OUTPUT "#include \"tables.h\"\n";
print OUTPUT "\n";
print OUTPUT "const char * const nasm_stdmac[] = {";

foreach $fname ( @ARGV ) {
    open(INPUT,$fname) or die "unable to open $fname\n";
    print OUTPUT "\n    /* From $fname */\n";
    while (<INPUT>) {
	$line++;
	chomp;
	if (m/^\s*\*END\*TASM\*MACROS\*\s*$/) {
	    $tasm_count = $index;
	    print OUTPUT "    /* End of TASM macros */\n";
	} elsif (m/^\s*((\s*([^\"\';\s]+|\"[^\"]*\"|\'[^\']*\'))*)\s*(;.*)?$/) {
	    $_ = $1;
	    s/\\/\\\\/g;
	    s/"/\\"/g;
	    if (length > 0) {
		print OUTPUT "        \"$_\",\n";
		$index++;
	    }
	} else {
	    die "$fname:$line:  error unterminated quote";
	}
    }
    close(INPUT);
}
print OUTPUT "\n    NULL\n};\n\n";
$tasm_count = $index unless ( defined($tasm_count) );
print OUTPUT "const char * const * nasm_stdmac_after_tasm = ",
    "&nasm_stdmac[$tasm_count];\n";
close(OUTPUT);
