--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Text_IO;
with Ada.Exceptions;
with Ada.Command_Line;
with Ada.Strings.Unbounded;
with Options;

with narval_aws_Service.Client;

procedure Narval_Shell_Body is
   use Ada.Strings.Unbounded;
   Exec_Line : Unbounded_String;
   use narval_aws_Service.Client;
begin
   if not Options.Present_Option ("end_point") then
      Ada.Text_IO.Put_Line ("end_point option need to be present !");
      return;
   end if;
   declare
      End_Point : constant String := Options.Get_Option ("end_point");
   begin
      if Ada.Command_Line.Argument_Count > 2 then
         for I in 3 .. Ada.Command_Line.Argument_Count loop
            if I = 3 then
               Exec_Line := To_Unbounded_String
                 (Ada.Command_Line.Argument (I));
            else
               Exec_Line := Exec_Line & " " & Ada.Command_Line.Argument (I);
            end if;
         end loop;
         Ada.Text_IO.Put_Line
           (Send_Command_With_Arguments (To_String (Exec_Line),
                                         (1 => (String_Value =>
                                                  Null_Unbounded_String)),
                                         End_Point));
         return;
      end if;
      loop
         Ada.Text_IO.Put ("narval shell>");
         declare
            Shell_Line : String (1 .. 256);
            Longueur_Ligne : Natural;
         begin
            Ada.Text_IO.Get_Line (Shell_Line, Longueur_Ligne);
            if Longueur_Ligne /= 0 then
               if Shell_Line (Shell_Line'First .. Longueur_Ligne) = "quit" then
                  return;
               end if;
               Ada.Text_IO.Put_Line
                 (Send_Command_With_Arguments
                  (Shell_Line (1 .. Longueur_Ligne),
                   (1 => (String_Value =>
                            Null_Unbounded_String)),
                   End_Point));
            end if;
         exception
            when E : others =>
               Ada.Text_IO.Put_Line ("some code raised an exception : " &
                                     Ada.Exceptions.Exception_Name (E));
               Ada.Text_IO.Put_Line ("with the message : " &
                                     Ada.Exceptions.Exception_Message (E));
         end;
      end loop;
   end;
end Narval_Shell_Body;
