--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with System;
with Interfaces;

with Shared_Library;
pragma Elaborate_All (Shared_Library);

package Narval.Actors.Actives.Filters is

   type Generic_Filter_Type is new
     Active_Actor_Type (An_Intermediary) with private;
   procedure Set (Object : access Generic_Filter_Type;
                  Parameter : String;
                  Value : String);

   procedure Initialise (Object : access Generic_Filter_Type;
                         Actor_Name : String);

private

   type Error_Code_Type is new Interfaces.Unsigned_32;
   type Error_Code_Access is access all Error_Code_Type;
   type Integer_Access is access Integer;
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Integer_Access);
   type Process_Config is access procedure (Directory_Path : String;
                                            Error_Code : out Error_Code_Type);
   pragma Convention (C, Process_Config);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Process_Config);
   type Process_Register is access function (Error_Code : Error_Code_Access)
                                            return System.Address;
   pragma Convention (C, Process_Register);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Process_Register);
   type Process_State_Change is access procedure
     (Algo_Data : System.Address; Error_Code : out Error_Code_Type);
   pragma Convention (C, Process_State_Change);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Process_State_Change);
   type Process_Block is access procedure
     (Algo_Data : System.Address;
      Input_Buffer : System.Address;
      Size_Of_Input_Buffer : Interfaces.Unsigned_32;
      Output_Buffer : System.Address;
      Size_Of_Output_Buffer : Interfaces.Unsigned_32;
      Used_Size_Of_Output_Buffer : out Interfaces.Unsigned_32;
      Error_Code : out Error_Code_Type);
   pragma Convention (C, Process_Block);
   function Library_Symbol is new
     Shared_Library.Library_Symbol (Process_Block);

   type Generic_Filter_Type is new Active_Actor_Type (An_Intermediary)
     with record
      Library_Is_Loaded : Boolean := False;
      Buffer_Handling_Switchoff : Boolean := False;
      Library_Reference : Shared_Library.Handle_Type;
      Common_Reference : System.Address;
      Config : Process_Config := null;
      Register : Process_Register := null;
      Block_Producer : Process_Block := null;
      Initialise : Process_State_Change := null;
      Reset : Process_State_Change := null;
      Start : Process_State_Change := null;
      Stop : Process_State_Change := null;
      Pause_Ptr : Process_State_Change := null;
      Resume : Process_State_Change := null;
      Unload : Process_State_Change := null;
      Max_Size : Natural := 0;
   end record;

   procedure Buffer_Handling (Object : access Generic_Filter_Type);
   procedure On_Unload (Object : access Generic_Filter_Type);
   procedure On_Start (Object : access Generic_Filter_Type);
   procedure On_Stop (Object : access Generic_Filter_Type);
   procedure On_Suspend (Object : access Generic_Filter_Type);
   procedure On_Resume (Object : access Generic_Filter_Type);
   procedure On_Initialise (Object : access Generic_Filter_Type);
   procedure On_Reset_Com (Object : access Generic_Filter_Type);
end Narval.Actors.Actives.Filters;
