--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Strings.Unbounded;

with Narval.Configurator.Actors_Description;
with Narval.State_Machine;

with Log4ada.Loggers;
with Log4ada.Appenders.Consoles;
with Log4ada.Appenders.Annex_E;

package Narval.Configurator.Abstract_Actors_Coordination.Actors_Coordination is

   type Actor_Coordination_Type is new Configuration_Type with record
      Name : Ada.Strings.Unbounded.Unbounded_String;
      Prefix : Ada.Strings.Unbounded.Unbounded_String;
      Delay_To_Wait : Natural := 50; -- in 0.1 second ticks
      Delay_To_Wait_Before_Mass_Killing : Natural := 0; -- in 1 second ticks
      Configuration_File : Ada.Strings.Unbounded.Unbounded_String :=
        Ada.Strings.Unbounded.Null_Unbounded_String;
      Actors : Actors_Description.Actors_Description_Vector.Vector;
      Slave_State_Machine : State_Machine.Machine;
      End_Process : Boolean := False;
      Run_Number : Integer := 1;
      Logger : aliased Log4ada.Loggers.Logger_Type;
      Console : aliased Log4ada.Appenders.Consoles.Console_Type;
      Remote_Appender :
        aliased Log4ada.Appenders.Annex_E.Remote_Appender_Type;
      Run_Numbering : Boolean := True;
   end record;
   type Actor_Coordination_Class_Access is
     access all Actor_Coordination_Type'Class;
   function Get_Configuration_Files
     (Config : access Actor_Coordination_Type) return String;
   procedure Special_Domi (Config : access Actor_Coordination_Type);
   function Current_State (Config : access Actor_Coordination_Type)
                         return Acquisition_State_Type;
   procedure Change_State (Config : access Actor_Coordination_Type;
                           Order : Action);
   function Order_Coherency (Config : access Actor_Coordination_Type;
                            Order : Action) return Boolean;
   function Available_Orders (Config : access Actor_Coordination_Type)
                              return Action_Array;
   function Get_Xml (Config : access Actor_Coordination_Type;
                     Parameter : String) return String;
   function Get_Image (Config : access Actor_Coordination_Type;
                       Parameter_Name : String) return String;
   procedure Set (Config : access Actor_Coordination_Type;
                  Parameter_Name : String;
                  Value : String);
   procedure Trig_Event (Config : access Actor_Coordination_Type;
                         Event : String);
   function Arguments (Config : access Actor_Coordination_Type;
                       Xml : Boolean := True) return String;

   procedure Register (Config : access Actor_Coordination_Type;
                       Name : String;
                       Pointer : Actors.Actor_Class_Access);
   function Get_Actor (Config : access Actor_Coordination_Type;
                        Name : String) return Actors.Actor_Class_Access;
   function Get_Active_Actors
     (Config : access Actor_Coordination_Type)
     return Actors.Actor_Class_Access_Array;

   function Get_Informations
     (Config : access Actor_Coordination_Type; Name : String) return String;

   procedure End_Actor_Handler (Config : access Actor_Coordination_Type);
   function Have_To_End (Config : Actor_Coordination_Type) return Boolean;
   procedure Initialise (Config : in out Actor_Coordination_Type;
                          Configuration_Name : String);
end Narval.Configurator.Abstract_Actors_Coordination.Actors_Coordination;
