--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Narval.Actors;
with Narval.Communication.Fifos;
with Narval.Communication.Sockets;
with Narval.Configurator.Abstract_Actors_Coordination;
with Narval.Local_Configuration;

package body Narval.Communication.Handling is

   -------------
   -- Liberer --
   -------------

   procedure Free (Link : in out Link_Access) is
   begin
      if Link.all in Sockets.Client_Socket_Link_Type'Class then
         Sockets.Free (Sockets.Client_Socket_Link_Access (Link));
      elsif Link.all in Sockets.Server_Socket_Link_Type'Class then
         Sockets.Free (Sockets.Server_Socket_Link_Access (Link));
      elsif Link.all in Fifos.Client_Fifo_Link_Type'Class then
         Fifos.Free (Fifos.Client_Fifo_Link_Access (Link));
      elsif Link.all in Fifos.Server_Fifo_Link_Type'Class then
         Fifos.Free (Fifos.Server_Fifo_Link_Access (Link));
      end if;
   end Free;

   -------------------------
   -- Nouveau_Lien_Client --
   -------------------------

   function New_Client_Link
     (Input : Configurator.Actors_Description.Receiver_Descriptor_Type;
      Asker : String;
      Logger : Log4ada.Loggers.Logger_Class_Access)
     return Link_Access
   is
      use Ada.Strings.Unbounded;
      Data_Source_Name : constant String := To_String (Input.Data_Source);
      Data_Source : Actors.Actor_Class_Access;
      use type Actors.Actor_Class_Access;
      Temp_Link : Link_Access;
   begin
      loop
         Data_Source := Configurator.Abstract_Actors_Coordination.Get_Actor
           (Local_Configuration.Config_Local, Data_Source_Name);
         if Data_Source /= null then
            exit;
         end if;
         delay Default_Waiting_Duration;
      end loop;
      declare
         Link_Parameter : constant Link_Descriptor_Type :=
           Actors.Get_Available_Link
           (Data_Source,
            Asker,
            To_String (Input.Port),
            To_String (Input.Name));
      begin
         if Input.Port = "fifo" then
            for I in Link_Parameter.Queue'Range loop
               Log4ada.Loggers.Debug_Out
                 (Logger,
                  "Nouveau_Lien_Client :" &
                    Link_Parameter.Queue (I)'Img);
               if Link_Parameter.Queue (I) /= 0 then
                  Temp_Link := Fifos.Init_Client
                    (Link_Parameter.Queue (I),
                     Logger);
                  Temp_Link.Provider := To_Unbounded_String
                    (Data_Source_Name);
                  return Temp_Link;
               end if;
            end loop;
            return null;
         else
            Temp_Link := Sockets.Init_Client
              (Link_Parameter.Link.Port_Number,
               Link_Parameter.Link.Address,
               Logger);
            Temp_Link.Provider := To_Unbounded_String
              (Data_Source_Name);
            return Temp_Link;
         end if;
      end;
   end New_Client_Link;

   --------------------------
   -- Nouveau_Lien_Serveur --
   --------------------------

   function New_Server_Link
     (Output : Configurator.Actors_Description.Sender_Descriptor_Type;
      Logger : Log4ada.Loggers.Logger_Class_Access)
     return Link_Array_Access is
      Links : Link_Array_Access;
      Null_Link_Pointer : exception;
      use Ada.Strings.Unbounded;
      Server : Sockets.Server_Socket_Link_Access;
   begin
      Log4ada.Loggers.Debug_Out (Logger, "*** New_Server_Link : enter ***");
      Log4ada.Loggers.Debug_Out (Logger,
                                 "*** New_Server_Link " &
                                   Output.Consumers_Number'Img &
                                   " ***");
      Links := new Link_Array (1 .. Positive (Output.Consumers_Number));
      for I in Links'Range loop
         if Output.Port = "fifo" then
            Links (I) := Fifos.Init_Server (Logger);
         else
            if I = Links'First then
               Server := Sockets.Init_Server (To_String (Output.Port),
                                              True,
                                              null,
                                              Logger);
               Links (Links'First) := Link_Access (Server);
               Server := Server.Server_Access;
            else
               Links (I) := Link_Access (Sockets.Init_Server
                                           (To_String (Output.Port),
                                            False,
                                            Server,
                                            Logger));
            end if;
         end if;
      end loop;
      for I in Links'Range loop
         if Links (I) = null then
            Log4ada.Loggers.Fatal_Out (Logger,
                                       "un des liens (" & I'Img & " /" &
                                         Links'Length'Img &
                                         " ) nuls : pb");
            raise Null_Link_Pointer;
         end if;
      end loop;
      Log4ada.Loggers.Debug_Out (Logger, "*** exit Nouveau_Lien_Serveur ***");
      return Links;
   end New_Server_Link;

end Narval.Communication.Handling;
