--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
package body Start_Stop_Handling is
   protected body Synchro_Start_Type is
      procedure Stop is
      begin
         Running := False;
      end Stop;
      procedure Start is
      begin
         Running := True;
      end Start;
      entry Is_Running when Running is
      begin
         null;
      end Is_Running;
      entry Is_Stopped when not Running is
      begin
         null;
      end Is_Stopped;
      function Is_Running return Boolean is
      begin
         return Running;
      end Is_Running;
      function Is_Stopped return Boolean is
      begin
         return not Running;
      end Is_Stopped;
   end Synchro_Start_Type;

   protected body Synchro_Pause_Type is
      procedure Resume is
      begin
         Paused := False;
      end Resume;
      procedure Pause is
      begin
         Paused := True;
      end Pause;
      entry Set_Pause_Off when not Paused is
      begin
         null;
      end Set_Pause_Off;
      entry Set_Pause_On when Paused is
      begin
         null;
      end Set_Pause_On;
      function Is_Paused return Boolean is
      begin
         return Paused;
      end Is_Paused;
   end Synchro_Pause_Type;

end Start_Stop_Handling;
