--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------

separate (Low_Level_Network.Utils)

function Get_Interfaces return Interfaces_Array is
   Fd : Integer;
   Interfaces : Address_Req_Array (1 .. 20);
   Ifconf : Ifconf_Type := (Interfaces'Size / 8,
                            Interfaces (1)'Address);
   C_Fct_Return : Integer;
   Interfaces_Number : Natural;
begin
   Fd := Socket (PF_INET, SOCK_DGRAM, IPPROTO_IP);
   if Fd = -1 then
      raise Bad_Call;
   end if;
   C_Fct_Return := Ioctl (Fd, SIOCGIFCONF, Ifconf'Address);
   if C_Fct_Return = -1 then
      raise Bad_Call;
   end if;
   C_Fct_Return := Close (Fd);
   if C_Fct_Return = -1 then
      raise Bad_Call;
   end if;
   Interfaces_Number := 8 * Ifconf.Length / Address_Req_Type'Size;
   declare
      Interfaces_To_Return : Interfaces_Array (1 .. Interfaces_Number);
      Name_Index : Positive;
      use Ada.Strings.Unbounded;
   begin
      for I in 1 .. Interfaces_Number loop
         Name_Index := 1;
         loop
            exit when Interfaces (I).Interface_Name (Name_Index) = ASCII.NUL;
            Interfaces_To_Return (I).Name :=
              Interfaces_To_Return (I).Name &
              Interfaces (I).Interface_Name (Name_Index);
            Name_Index := Name_Index + 1;
         end loop;
         Interfaces_To_Return (I).Address := (Interfaces (I).Address (3),
                                              Interfaces (I).Address (4),
                                              Interfaces (I).Address (5),
                                              Interfaces (I).Address (6));
      end loop;
      return Interfaces_To_Return;
   end;
end Get_Interfaces;
