#include <stdio.h>
#include <stdlib.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <string.h>
#if defined(__FreeBSD_kernel__)
#include <sys/sockio.h>
#endif
int main (int argc, char **argv)
{
  if (argc == 1)
    {
      printf ("usage :\n%s {--sockaddr|--ifreq|--SIOCGIFCONF|--SIOCGIFADDR}\n",
	      argv[0]);
      return 1;
    }
  if (argc > 2)
    {
      printf ("only one arg allowed\n");
      printf ("usage :\n%s {--sockaddr|--ifreq|--SIOCGIFCONF|--SIOCGIFADDR}\n",
              argv[0]);
      return 2;
    }
  if (strcmp(argv[1],"--SIOCGIFCONF") == 0)
    {
      printf ("%lx\n",SIOCGIFCONF);
    }
  if (strcmp(argv[1],"--SIOCGIFADDR") == 0)
    {
      printf ("%lx\n",SIOCGIFADDR);
    }
  if (strcmp(argv[1],"--sockaddr") == 0)
    {
      printf ("%lu\n",sizeof(struct sockaddr));
    }
  if (strcmp(argv[1],"--ifreq") == 0)
    {
      printf ("%lu\n",sizeof(struct ifreq));
    }
  return 0;
}
