--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Narval.Configurator.Actors_Description;
with Input_Sources.File;
with Input_Sources.Strings;
with Unicode.CES.Utf8;
with Ada.Command_Line;
with Ada.Text_IO;
with DOM.Readers;
with DOM.Core.Nodes;

procedure Test_Parsing is
   File : Input_Sources.File.File_Input;
   Input : Input_Sources.Strings.String_Input;
   String_Input : aliased String := "<producer output_buffers=""2"">" &
     "<name>actor_name</name>" &
     "<rank>1</rank>" &
     "</producer>";
   File_Reader : DOM.Readers.Tree_Reader;
   String_Reader : DOM.Readers.Tree_Reader;
   Actors : aliased
     Narval.Configurator.Actors_Description.Actors_Description_Vector.Vector;
   Actor : aliased
     Narval.Configurator.Actors_Description.Actor_Description_Type;
begin
   Input_Sources.File.Open (Ada.Command_Line.Argument (1),
                            File);
   DOM.Readers.Parse (File_Reader, File);
   Input_Sources.File.Close (File);
   Input_Sources.Strings.Open (String_Input'Unchecked_Access,
                               Unicode.CES.Utf8.Utf8_Encoding,
                               Input);
   DOM.Readers.Parse (String_Reader, Input);
   Input_Sources.Strings.Close (Input);
   Narval.Configurator.Actors_Description.Fill
     (DOM.Core.Nodes.First_Child (DOM.Readers.Get_Tree (String_Reader)),
      Actor);
   Narval.Configurator.Actors_Description.Display (Actor);
   Narval.Configurator.Actors_Description.Fill
     (DOM.Readers.Get_Tree (File_Reader), Actors);
   Narval.Configurator.Actors_Description.Rank_Calcul (Actors);
   Narval.Configurator.Actors_Description.Display (Actors);
   Ada.Text_IO.Put_Line
     (Narval.Configurator.Actors_Description.To_String (Actor));
end Test_Parsing;
