--------------------------------------------------------------------------
--                                                                      --
--           Copyright: Copyright (C) 2000-2010 CNRS/IN2P3              --
--                                                                      --
-- Narval framework is free  software; you can redistribute  it and/or  --
-- modify  it   under  terms  of  the  GNU General  Public  License as  --
-- published  by  the  Free Software Foundation; either version  2, or  --
-- (at your option) any later version. Narval framework is distributed  --
-- in the hope  that  they will  be useful, but  WITHOUT ANY WARRANTY;  --
-- without even the implied warranty of  MERCHANTABILITY or FITNESS FOR --
-- A PARTICULAR PURPOSE. See the  GNU. General Public License for more  --
-- details. You should have received  a copy of the GNU General Public  --
-- License distributed with Narval; see file COPYING. If not, write to  --
-- the Free Software  Foundation,  Inc., 51 Franklin St,  Fifth Floor,  --
-- Boston, MA 02110-1301 USA.                                           --
--------------------------------------------------------------------------
with Ada.Unchecked_Deallocation;
with GNAT.OS_Lib;

with Log4ada.Loggers;

package Narval.Communication.Fifos is
   type Fifo_Link_Type is abstract new Link_Type with record
      Root : Integer;
      Fd_Send : GNAT.OS_Lib.File_Descriptor;
      Fd_Receive : GNAT.OS_Lib.File_Descriptor;
   end record;

   function Get_Init_Info (Link : access Fifo_Link_Type)
                                          return Integer;
   function Stream (Link : access Fifo_Link_Type) return Stream_Access;
   procedure Free (Link : access Fifo_Link_Type;
                   Stream_To_Free : in out Stream_Access);
   procedure Send (Link : access Fifo_Link_Type;
                      Data : Ada.Streams.Stream_Element_Array);
   procedure Receive (Link : access Fifo_Link_Type;
                       Data : out Ada.Streams.Stream_Element_Array);

   type Client_Fifo_Link_Type is new Fifo_Link_Type with null record;
   type Client_Fifo_Link_Access is access all Client_Fifo_Link_Type;

   procedure Connect (Link : access Client_Fifo_Link_Type;
                      Bit_Order_To_Send : in out System.Bit_Order);
   procedure Close (Link : access Client_Fifo_Link_Type);

   type Server_Fifo_Link_Type is new Fifo_Link_Type with null record;

   type Server_Fifo_Link_Access is access all Server_Fifo_Link_Type;

   procedure Connect (Link : access Server_Fifo_Link_Type;
                      Bit_Order_To_Send : in out System.Bit_Order);
   procedure Close (Link : access Server_Fifo_Link_Type);

   Invalid_Link : exception;
   --  fonctions generales
   function Init_Client (File : Integer;
                         Logger : Log4ada.Loggers.Logger_Class_Access)
                        return Link_Access;
   function Init_Server (Logger : Log4ada.Loggers.Logger_Class_Access)
                        return Link_Access;
   procedure Free is new Ada.Unchecked_Deallocation
     (Client_Fifo_Link_Type, Client_Fifo_Link_Access);
   procedure Free is new Ada.Unchecked_Deallocation
     (Server_Fifo_Link_Type, Server_Fifo_Link_Access);

end Narval.Communication.Fifos;
