# #########################################################
#
# NAME:         
#       myodbcinst.pro
#
# PURPOSE:
#       Use qt qmake on this to make the Makefile.
#
# DESCRIPTION:
#       This file is really only for XP because UNIX, 
#       Linux, and OSX can use the gnu automake.
#
#       This file exists for those that have qt (such as
#       myself). Others may simply use the Makefile.win
#
#       By default PORTABLE_GUI is defined here so the
#       assumption is that you are working with the Qt
#       based setup library.
#
# #########################################################

# #########################################################
# COMMON
# #########################################################

TEMPLATE                = app
TARGET                  = myodbcinst
DESTDIR                 = ./
OBJECTS_DIR             = ./
CONFIG                  += thread console
DEFINES           	+= HAVE_SQLGETPRIVATEPROFILESTRING HAVE_ODBCINST_H PORTABLE_GUI

# #########################################################
# WIN
# #########################################################
win32:DEFINES           -= UNICODE
win32:DEFINES           += WIN32
win32:LIBS              += ..\util\myodbcutil.lib odbc32.lib odbccp32.lib

# #########################################################
# UNIX
# #########################################################
unix:LIBS               += -L../util -lmyodbcutil -L/usr/lib -lodbc -lodbcinst -lltdl

# #########################################################
# OSX
# #########################################################
mac:CONFIG		-= thread
mac:DEFINES		-= HAVE_ODBCINST_H
mac:DEFINES		+= HAVE_IODBCINST_H
mac:LIBS		-= -lodbc -lodbcinst
mac:LIBS		+= -liodbc -liodbcinst

# #########################################################
# FILES
# #########################################################
HEADERS			=

SOURCES			= \
                        myodbcinst.c

