/***************************************************************************
                          mytest.h  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Venu, MySQL AB
    email                : venu@mysql.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __TMYODBC__TEST__H
#define __TMYODBC__TEST__H

#ifdef HAVE_CONFIG_H
#include <myconf.h>
#endif

#ifdef WIN32
#include <windows.h>
#endif 

#ifndef MY_DEBUG
#define MY_DEBUG
#endif

/* STANDARD C HEADERS */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

/* ODBC HEADERS */
#include <sql.h>
#include <sqlext.h>

#ifndef NULL
#define NULL 0
#endif

#ifndef ushort
#define ushort unsigned short
#endif

#ifndef bool
#define bool unsigned char
#endif

#ifndef true
#define true 1
#endif

#ifndef false
#define false 0
#endif

#ifndef my_assert
#define my_assert assert
#endif

#ifndef myassert
#define myassert assert
#endif

#ifndef Sleep
#define Sleep _sleep
#endif

#ifdef MY_DEBUG
#define myprintf printf
#else
#define myprintf
#endif

#define MAX_NAME_LEN 95
#define MAX_COLUMNS 255
#define MAX_ROW_DATA_LEN 255

SQLCHAR *mydsn = "test";
SQLCHAR *myuid = "root";
SQLCHAR *mypwd = "";

/* PROTOTYPE */
void myerror(SQLRETURN rc,SQLHENV henv,SQLHDBC hdbc,SQLHSTMT hstmt);
SQLUINTEGER myresult(SQLHSTMT hstmt);

/* UTILITY MACROS */
#define myenv(henv,r) if ( ((r) != SQL_SUCCESS) ) myerror(r, henv, NULL, NULL); my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )
#define myenv_err(henv,r,rc) if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, henv, NULL, NULL); my_assert( r )
#define myenv_r(henv,rc) if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, henv, NULL, NULL); my_assert( rc == SQL_ERROR)
#define mycon(hdbc,r)  if ( ((r) != SQL_SUCCESS) ) myerror(r, NULL, hdbc, NULL); my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )
#define mycon_err(hdbc,r,rc)  if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, NULL, hdbc, NULL); my_assert( r )
#define mycon_r(hdbc,rc) if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, NULL, hdbc, NULL); my_assert( rc == SQL_ERROR)
#define mystmt(hstmt,r) if ( ((r) != SQL_SUCCESS) ) myerror(r, NULL, NULL, hstmt); my_assert( ((r) == SQL_SUCCESS) || ((r) == SQL_SUCCESS_WITH_INFO) )
#define mystmt_err(hstmt,r,rc)  if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, NULL, NULL, hstmt); my_assert( r )
#define mystmt_r(hstmt,rc) if ( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) myerror(rc, NULL, NULL, hstmt); my_assert( rc == SQL_ERROR)
#define myheader(str) { myprintf("\n######################################\n"); myprintf("%s",str); myprintf("\n######################################\n"); }
/**
ERROR HANDLER
*/
void myerror(SQLRETURN rc, SQLHENV henv, SQLHDBC hdbc, SQLHSTMT hstmt)
{
  RETCODE lrc;

  if( rc == SQL_ERROR || rc == SQL_SUCCESS_WITH_INFO ) 
  {
    SQLCHAR      szSqlState[6],szErrorMsg[SQL_MAX_MESSAGE_LENGTH];
    SQLINTEGER   pfNativeError;
    SQLSMALLINT pcbErrorMsg;

    lrc = SQLError(henv,hdbc,hstmt,
        (SQLCHAR *)&szSqlState,
        (SQLINTEGER *)&pfNativeError,
        (SQLCHAR *)&szErrorMsg,
         SQL_MAX_MESSAGE_LENGTH-1,
        (SQLSMALLINT *)&pcbErrorMsg);

    if(lrc == SQL_SUCCESS || lrc == SQL_SUCCESS_WITH_INFO)
      myprintf("\n%d,[%s][%d:%s]\n",rc,szSqlState,pfNativeError,szErrorMsg);
    else 
      myprintf("SQLError returned :%d, but rc = %d\n",lrc,rc);
  }
}
/**
  CONNECTION
*/
void myconnect(SQLHENV *henv,SQLHDBC *hdbc, SQLHSTMT *hstmt)
{
  SQLRETURN rc;

    rc = SQLAllocEnv(henv);
    myenv(*henv,rc);    

    rc = SQLAllocConnect(*henv, hdbc);
    myenv(*henv,rc);    

    myprintf("connecting to '%s' with user name '%s'...\n",mydsn,myuid);
    rc = SQLConnect(*hdbc, mydsn, SQL_NTS, myuid, SQL_NTS,  mypwd, SQL_NTS);
    mycon(*hdbc,rc);

    rc = SQLSetConnectOption(*hdbc,SQL_AUTOCOMMIT,SQL_AUTOCOMMIT_ON);
    mycon(*hdbc,rc);

    rc = SQLAllocStmt(*hdbc, hstmt);
    mycon(*hdbc,rc);

    rc = SQLSetStmtOption(*hstmt,SQL_CURSOR_TYPE,SQL_CURSOR_STATIC);
    mystmt(*hstmt,rc);

  /* MS SQL Server to work...*/
#if 0
  SQLSetStmtAttr(hstmt, SQL_ATTR_CONCURRENCY, (SQLPOINTER) SQL_CONCUR_ROWVER, 0);
  SQLSetStmtAttr(hstmt, SQL_ATTR_CURSOR_TYPE, (SQLPOINTER) SQL_CURSOR_KEYSET_DRIVEN, 0);
#endif
}
/**
  DISCONNECT
*/
void mydisconnect(SQLHENV *henv,SQLHDBC *hdbc, SQLHSTMT *hstmt)
{
  SQLRETURN rc;

    rc = SQLFreeStmt(*hstmt, SQL_DROP);
    mystmt(*hstmt,rc);

    rc = SQLDisconnect(*hdbc);
    mycon(*hdbc,rc);

    rc = SQLFreeConnect(*hdbc);
    mycon(*hdbc,rc);

    rc = SQLFreeEnv(*henv);
    myenv(*henv,rc);
}
/**
  RESULT SET
*/
SQLUINTEGER myresult(SQLHSTMT hstmt)
{
  SQLRETURN   rc;
  SQLUINTEGER nRowCount=0, pcColDef;
  SQLCHAR     szColName[MAX_NAME_LEN];
  SQLCHAR     szData[MAX_COLUMNS][MAX_ROW_DATA_LEN]={0};
  SQLSMALLINT nIndex,ncol,pfSqlType, pcbScale, pfNullable;

  rc = SQLNumResultCols(hstmt,&ncol);
  mystmt(hstmt,rc);

  myprintf("\n");

  for(nIndex = 1; nIndex <= ncol; nIndex++)
  {
    rc = SQLDescribeCol(hstmt,nIndex,szColName, MAX_NAME_LEN+1, NULL,
                        &pfSqlType,&pcColDef,&pcbScale,&pfNullable);
    mystmt(hstmt,rc);

    myprintf("%s\t",szColName);

    rc = SQLBindCol(hstmt,nIndex, SQL_C_CHAR, szData[nIndex-1],
                    MAX_ROW_DATA_LEN+1,NULL);
    mystmt(hstmt,rc);
  }

  myprintf("\n------------------------------------------------------\n");

  rc = SQLFetch(hstmt);
  while(rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)
  {
     nRowCount++;
     for(nIndex=0; nIndex< ncol; nIndex++)
       myprintf("%s\t",szData[nIndex]);
     
     myprintf("\n");
     rc = SQLFetch(hstmt);
   }
   SQLFreeStmt(hstmt,SQL_UNBIND);

   myprintf("\n total rows fetched:%d\n",nRowCount);
   return(nRowCount);
}
/**
  SQLExecDirect
*/
SQLRETURN tmysql_exec(SQLHSTMT hstmt, SQLCHAR *sql_stmt)
{
  return(SQLExecDirect(hstmt,sql_stmt,SQL_NTS));
}
/**
  SQLPrepare
*/
SQLRETURN tmysql_prepare(SQLHSTMT hstmt, SQLCHAR *sql_stmt)
{
  return(SQLPrepare(hstmt,sql_stmt,SQL_NTS));
}
/**
  return integer data by fetching it
*/
SQLINTEGER my_fetch_int(SQLHSTMT hstmt, SQLUSMALLINT irow)
{
  SQLINTEGER nData;

  SQLGetData(hstmt,irow,SQL_INTEGER,&nData,0,NULL);
  myprintf("my_fetch_int:%d\n",nData);
  return(nData);  
}
/**
  return string data, by fetching it
*/
const char *my_fetch_str(SQLHSTMT hstmt, SQLCHAR *szData,SQLUSMALLINT irow)
{
  SQLINTEGER nLen=0;

  SQLGetData(hstmt,irow,SQL_CHAR,szData,MAX_ROW_DATA_LEN+1,&nLen);
  myprintf("my_fetch_str:%s(%d)\n",szData,nLen);
  return((const char *)szData);  
}

#endif /* __TMYODBC__TEST__H */


