// rubbertext.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <InterViews/painter.h>
#include "rubbertext.h"

static const int MaxRubberTextLen = 64;

inline void
RubberText::setText(const char *t) {
	strcpy(oldstring, string);
	strcpy(string, t);
}

RubberText::RubberText(Painter *p, Canvas *c, Coord x, Coord y,
		const char *text) : Rubberband(p, c, x, y), erasing(false) {
	string = new char[MaxRubberTextLen];
	*string = '\0';
	oldstring = new char[MaxRubberTextLen];
	setText(text ? text : "");
}

RubberText::~RubberText() {
	delete [] string;
	delete [] oldstring;
}

void
RubberText::SetPainter(Painter* p) {
	Rubberband::SetPainter(p);
}

void
RubberText::Draw() {
	if (!drawn) {
		output->Text(canvas, erasing ? oldstring : string,
			trackx+offx, tracky+offy);
		drawn = true;
	}
}

void
RubberText::Erase() {
	erasing = true;
	Rubberband::Erase();
	erasing = false;
}

void
RubberText::Track(const char *t, Coord x, Coord y) {
	trackx = -1000; tracky = -1000;	// reset to allow redraw without motion
	setText(t);
	Rubberband::Track(x, y);
}
