// pchdata.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Data subclass specialized for storing and manipulation of pitch tracking
// analysis data.  For compatibility with Paul Lansky's Cmix pitch tracking
// programs, the second channel of data contains the RMS amplitude of each
// frame.

#ifndef PCHDATA_H
#ifdef __GNUG__
#pragma interface
#endif
#define PCHDATA_H

#include "framedata.h"

class DataFile;
class Header;
class Range;
class Controller;

class PCHData : public FrameData {
	typedef FrameData Super;
public:
	PCHData(int length=16, int srate=44100, double frate=200, int fsize=350)
		: FrameData(FloatData, length, 2, srate, frate), framesize(fsize) {}
	virtual ~PCHData() {}
	redefined Data *newData(int length);
	redefined Data *clone(const Range &r);
	redefined Data *clone(const Range &r, const Range &c);
	virtual int frameSize() const { return framesize; }
	redefined void print(FILE *);

	redefined FileType fileType() const { return PCH_Data; }
	redefined const char *fileSuffix() const { return ".pt"; }
	// information methods for display objects
	redefined const char* windowClassName() const { return "PitchWindow"; }
	redefined const char* horizontalScaleModeAttribute() const {
		return "PitchWindowHorizontalScale";
	}
	redefined const char* channelDisplayAttribute() const {
		return "PitchWindowDisplayChannels";
	}
	redefined const char* defaultDirAttribute() const {
		return "DefaultPitchFileDir";
	}
	redefined const char* channelName(int chan) const;
	redefined void information(Controller *);
	redefined Header* createHeader(DataFile *, boolean reading);
protected:
	PCHData(const PCHData *p) : FrameData(p), framesize(p->framesize) {}
	PCHData(const PCHData *p, int newlen) : FrameData(p, newlen),
		framesize(p->framesize) {}
	PCHData(const PCHData *p, const Range &selection)
		: FrameData(p, selection), framesize(p->framesize) {} 

	PCHData(const PCHData *p, const Range &selection, const Range &chans)
		: FrameData(p, selection, chans), framesize(p->framesize) {} 
	redefined void readFromHeader(Header *);
private:
	int framesize;
};

#endif
