// edit_menus.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include "localdefs.h"
#include <X11/keysym.h>
#include "data.h"
#include "editor.h"
#include "menus.h"
#include "cmdstate.h"
#include "pvoceditor.h"
#include "soundeditor.h"
#include "sndconfig.h"

// The structs containing the various menuitem templates for the menus

static MenuInfo viewModeSubmenu[] = {
    { "View as channels",	" ",    XK_copyright },
    { "View as frames",		" ",    XK_ordfeminine },
    { nil }
};

static MenuInfo channelSubmenu[] = {
    { "Set channel view...",	"=",    XK_equal },
    { "Add channel",			"+",    XK_plus },
    { "Remove channel",			"-",    XK_minus },
    { "Shift up",				">",    XK_greater },
    { "Shift down",				"<",    XK_less },
    { nil }
};

static MenuInfo viewMenu[] = {
    { "New view of selection",	"N",    XK_N, Target_Region_Selected },
    { "Zoom to selection",		"z",    XK_z, Target_Region_Selected },
    { "Zoom to full",			"Z",    XK_Z },
    { "Set frame view...",		"f",    XK_f },
    { "Reset vertical scale",	"V",    XK_V },
    { "View Mode",			"",	0L,	Nothing_Selected, viewModeSubmenu },
    { "Channel Display",	"",	0L, Nothing_Selected, channelSubmenu },
    { "Display copy buffer",    "I",    XK_I },
    { "Close current view",		"W",	XK_W },
    { nil }
};

static MenuInfo fileTypeSubmenu[] = {
    { "LPC datafile...",             " ",    XK_nobreakspace },
    { "Sound file...",               " ",    XK_exclamdown },
    { "Envelope...",                 " ",    XK_cent },
    { "Pvoc datafile...",            " ",    XK_currency },
    { nil }
};

static MenuInfo fileMenu[] = {
    { "Set default dir...",     ".",    XK_period },
    { "New",                    "n",    XK_n },
    { "New Type",               "",     0L,   0UL,  fileTypeSubmenu },
    { "Open...",                "o",    XK_o },
    { "Save",                   "s",    XK_s },
    { "Save as...",             "S",    XK_S },
    { "Save selection to file",	"",	XK_periodcentered, Target_Region_Selected },
    { "Revert to saved",        "", XK_threequarters, File_Is_Modified },
    { "Change name...",         "'",    XK_quoteright },
    { "Change file comment...", "\"",    XK_quotedbl },
    { "File information...",    "?", XK_question },
    { "Data dump of selection...", "}", XK_braceright, Target_Region_Selected },
    { "Show program version",        " ",    XK_yen },
    { "Quit program",                "Q",    XK_Q },
    { nil }
};

// the unusual keycodes are just for internal communication--no one is 
// expect to type those characters!

static MenuInfo editMenu[] = {
    { "Undo",						"u",    XK_u, Undo_Is_Available },
    { "Redo",						"U",    XK_U, Redo_Is_Available },
    { "Set insert point...",		"j",    XK_j },
    { "Set edit region...",			"J",    XK_J },
    { "Copy",						"c",    XK_c },
    { "Copy to new",				"C",    XK_C },
    { "Remove",						"r",    XK_r },
    { "Remove to new",				"y",    XK_y },
    { "Erase",						"e",    XK_e },
    { "Splice out selection",		"x",    XK_x, Target_Region_Selected },
    { "Splice out selection to new","X",    XK_X, Target_Region_Selected },
    { "Delete selection",			"d",    XK_d, Target_Region_Selected },
    { "Mix",						"m",    XK_m, Source_Selected },
    { "Replace",					"R",    XK_R, Source_Selected },
    { "Crossfade...",				"g",    XK_g, Source_Selected },
    { "Splice in",					"v",    XK_v, Source_Selected },
    { nil }
};

static MenuInfo modifyMenu[] = {
    { "Normalize values",           "[",    XK_bracketleft },
    { "Smooth curve",               "L",    XK_L },
    { "Autocorrelate selection...", "a",    XK_a,	Target_Region_Selected },
    { "Scale values...",            "P",    XK_P },
    { "Rescale to fit...",          "]",    XK_bracketright },
    { "Add offset...",              "O",    XK_O },
    { "Apply envelope...",          "E",    XK_E },
	{ "Fade in...",				"F1",	XK_F1 },
	{ "Fade out...",			"F2",	XK_F2 },
    { "Reverse",                "b",    XK_b },
    { "Swap bytes",             "{",    XK_braceleft },
    { "Insert space...",        "i",    XK_i, 		Target_Selected },
    { "Add delay...",            "D",    XK_D, 		Target_Selected },
    { "Stretch/shrink...",       "t",    XK_t },
    { nil }
};

static MenuInfo analysisMenu[] = {
    { "Locate next zero crossing",		"0",    XK_0 },
    { "Find slope change...",			"1",    XK_1 },
    { "Show peak frame location",		"2",    XK_2 },
    { "Extract amplitude envelope...",	"3",    XK_3 },
    { nil }
};

static MenuInfo styleSubmenu[] = {
    { "Line",    "%",    XK_percent },
    { "Bar",    "^",    XK_asciicircum },
    { nil }
};

static MenuInfo channelUnitSubmenu[] = {
    { "Frames",	"#",	XK_numbersign,	HDisplay_As_Frames },
    { "Time",	"@",	XK_at,			HDisplay_As_Time },
    { "SMPTE",	"!",	XK_exclam,		HDisplay_As_SMPTE },
    { "CDDA",	"|",    XK_bar,			HDisplay_As_CDDA },
    { nil }
};

static MenuInfo channelDisplayMenu[] = {
    { "Graph Style",        "",    0L, 0UL, styleSubmenu },
    { "Horiz Scale Units",    "",    0L, 0UL, channelUnitSubmenu },
    { nil }
};

static MenuInfo soundFilterSubmenu[] = {
    { "Low pass",               "L",    XK_L },
    { "Resonant",               "q",    XK_q },
    { "Comb",                   "K",    XK_K },
    { "Elliptical",             "H",    XK_H },
    { "FIR",                    "F",    XK_F,			Source_Selected },
    { "LPC formant",             " ",   XK_brokenbar,	Source_Selected },
    { nil }
};

static MenuInfo soundModifyMenu[] = {
    { "Adjust gain...",     "P",    XK_P },
    { "Apply envelope...",  "E",    XK_E },
	{ "Fade in...",			"F1",	XK_F1 },
	{ "Fade out...",		"F2",	XK_F2 },
    { "Reverse",            "b",    XK_b },
    { "Transpose...",       "t",    XK_t },
    { "Time shift...",      "T",    XK_T,			Command_Inactive },
    { "Filter",             "",     0L,				0UL, soundFilterSubmenu },
    { "Insert space...",    "i",    XK_i,			Target_Selected },
    { "Normalize values",   "[",    XK_bracketleft },
    { "Add delay...",       "D",    XK_D, 			Target_Selected },
    { "Add DC offset...",   "O",    XK_O },
    { "Remove DC offset",   "~",    XK_asciitilde },
    { "Swap bytes",         "{",    XK_braceleft },
    { nil }
};

static MenuInfo synthesisSubmenu[] = {
    { "LPC resynthesis...",             "K1",    XK_KP_1, Source_Selected },
    { "Phase Vocoder resynthesis...",   "K2",    XK_KP_2, Source_Selected },
    { nil }
};

static MenuInfo converterSubmenu[] = {
#ifdef SPARC_DACS
    { "SPARC",        "",    XK_section },
#elif defined SGI_DACS
    { "SGI",        "",    XK_section },
#elif defined SOUNDBLASTER
    { "SoundBlaster",    "",    XK_section },
#elif defined OSS
    { "OSS",    "",    XK_section },
#elif defined ALSA
    { "ALSA",    "",    XK_section },
#elif defined MACOSX
    { "OS X",    "",    XK_section },
#elif defined NeXT
    { "NeXT",        "",    XK_section },
#endif
#ifdef ADC_DACS
    { "ADR",        "",    XK_diaeresis },
#elif defined PROPORT_DACS
    { "S56x",        "",    XK_diaeresis },
#endif
    { "Converter settings...",        ")",    XK_parenright },
    { "Reset converter",            "",    XK_threesuperior },
    { nil }
};

static MenuInfo soundSpecialMenu[] = {
    { "Play",                         "p",    XK_p },
    { "Stop",                         "<backspace>",    XK_BackSpace },
    { "Rescan for peak",              "$",    XK_dollar },
    { "Rescale file",                 "]",    XK_bracketright },
    { "Record",                       ":",    XK_colon },
    { "Change file sample format...", "&",    XK_ampersand },
    { "Change file sample rate...",   "k",    XK_k },
    { "Change file length...",        "l",    XK_l },
    { "Synthesis",                    " ",    0L, 0UL, synthesisSubmenu },
    { "D/A Converter",                " ",    0L, 0UL, converterSubmenu },
    { "Sound options...",             " ",     XK_degree },
    { "Raw file options...",          " ",     XK_paragraph },
    { nil }
};

static MenuInfo soundAnalysisMenu[] = {
    { "Locate next zero crossing",		"0",    XK_0 },
    { "Find slope change...",			"1",    XK_1 },
    { "Show maxamp sample location",	"2",    XK_2 },
    { "Extract amplitude envelope...",	"3",    XK_3 },
    { "FFT analysis",					"4",    XK_4 },
    { "LPC analysis",					"5",    XK_5 },
    { "Extract pitch envelope",			"6",    XK_6 },
    { "LPC and pitch envelope",			"7",    XK_7 },
    { "Phase Vocoder analysis",			"8",    XK_8 },
    { "Find silence...",				"9",    XK_9 },
    { nil }
};

static MenuInfo peakRescanSubmenu[] = {
    { "On",        "/",    XK_slash },
    { "Off",    "\\",    XK_backslash },
    { nil }
};

static MenuInfo optionsMenu[] = {
    { "Global Options...",         " ",    XK_macron },
    { "Memory Options...",         " ",    XK_mu },
    { "File Options...",           " ",    XK_acute },
    { "Editor Options...",         " ",    XK_questiondown },
    { "Scale Options...",          " ",    XK_twosuperior },
    { "Peak Rescan",               "",     0L, 0UL, peakRescanSubmenu },
#if defined (OSS) || defined(MACOSX)
    { "Sound Playback Options...", " ",    XK_cedilla },
#endif
	{ "Re-read .mxvrc file",	" ",	XK_onesuperior },
	{ "Write .mxvrc file", 		" ",	XK_masculine },
    { nil }
};

static MenuInfo helpMenu[] = {
    { "MiXViews Home Page (via the web)", "F11",     XK_F11 },
    { "MiXViews Manual (via the web)", "F12",     XK_F12 },
    { nil }
};

// And now the structs containing the various menu templates

static MenuBarInfo defaultChannelMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Analysis ", analysisMenu },
    { " Display ", channelDisplayMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

static MenuBarInfo soundMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Modify ", soundModifyMenu },
    { " Sound ", soundSpecialMenu },
    { " Analysis ", soundAnalysisMenu },
    { " Display ", channelDisplayMenu },
    { " Options ", optionsMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

static MenuInfo lpcSpecialMenu[] = {
    { "Stabilize frames",        	"*",    XK_asterisk },
    { "Display filter amplitudes",	"A",    XK_A },
    { "Display filter formants",	"F",    XK_F },
	{ "Audition via resynthesis",	"p", 	XK_p },
    { "Stop audition",				"<backspace>",    XK_BackSpace },
    { "Merge pitch data",			"M",    XK_M,	Source_Selected },
    { "Adjust pitch deviation...",	"$",    XK_dollar },
    { "Change file sample rate...",	"k",    XK_k },
    { "Change file length...",		"l",    XK_l },
    { "LPC options...",				" ",    XK_degree },
    { nil }
};

static MenuBarInfo lpcMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Modify ", modifyMenu },
    { "  LPC  ", lpcSpecialMenu },
    { " Analysis ", analysisMenu },
    { " Display ", channelDisplayMenu },
    { " Options ", optionsMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

static MenuInfo envelopeSpecialMenu[] = {
    { "Create linear curve...",      "_",    XK_underscore },
    { "Create exponential curve...", "*",    XK_asterisk },
    { "Invert existing curve",       " ",    0L, Command_Inactive },
    { "Change file length...",       "l",    XK_l },
    { "Envelope options...",         " ",     XK_degree },
    { nil }
};

static MenuBarInfo envelopeMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Modify ", modifyMenu },
    { " Envelope ", envelopeSpecialMenu },
    { " Analysis ", analysisMenu },
    { " Display ", channelDisplayMenu },
    { " Options ", optionsMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

static MenuInfo pitchSpecialMenu[] = {
    { "Interpolate between endpoints", "_",    XK_underscore },
    { "Shift by pitch interval...",    " ",    0L, Command_Inactive },
    { "Change file length...",         "l",    XK_l },
    { nil }
};

static MenuBarInfo pitchMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Modify ", modifyMenu },
    { " Pitch ", pitchSpecialMenu },
    { " Analysis ", analysisMenu },
    { " Display ", channelDisplayMenu },
    { " Options ", optionsMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

static MenuInfo frameHorizUnitSubmenu[] = {
    { "Band numbers",    "#",    XK_numbersign },
    { "Frequency",        "@",    XK_at },
    { nil }
};

static MenuInfo frameVertUnitSubmenu[] = {
    { "Amplitude",        "a",    XK_a },
    { "Decibels",        "d",    XK_d },
    { nil }
};

static MenuInfo frameDisplayMenu[] = {
    { "Horiz. Scale Units",    "",    0L, 0UL, frameHorizUnitSubmenu },
    { "Vert. Scale Units",    "",    0L, 0UL, frameVertUnitSubmenu },
    { nil }
};

static MenuBarInfo defaultFrameMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { " Display ", frameDisplayMenu },
    { nil }
};

static MenuInfo pvocSpecialMenu[] = {
    { "Harmonically shift spectrum",    "h",    XK_h },
    { "Stretch/shrink shift spectrum",  "T",    XK_T },
    { "Expand/compress spectrum",       "X",    XK_X, Command_Inactive },
	{ "Audition via resynthesis",		"p", 	XK_p },
    { "Stop audition",          		"<backspace>",    XK_BackSpace },
    { "Change file length...",          "l",    XK_l },
    { "Pvoc options...",                " ",    XK_degree, Command_Inactive },
    { nil }
};

static MenuBarInfo pvocMenuBar[] = {
    { "  File  ", fileMenu },
    { "  View  ", viewMenu },
    { "  Edit  ", editMenu },
    { " Modify ", modifyMenu },
    { "  PVoc  ", pvocSpecialMenu },
    { " Analysis ", analysisMenu },
    { " Display ", channelDisplayMenu },
    { " Options ", optionsMenu },
	{ "  Help  ", helpMenu },
    { nil }
};

////////

const MenuBarInfo *
DataEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : defaultChannelMenuBar;
}

const MenuBarInfo *
SoundEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : soundMenuBar;
}

const MenuBarInfo *
LPCEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : lpcMenuBar;
}

const MenuBarInfo *
PvocEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : pvocMenuBar;
}

const MenuBarInfo *
PCHEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : pitchMenuBar;
}

const MenuBarInfo *
EnvelopeEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : envelopeMenuBar;
}

const MenuBarInfo *
FFTEditor::menuBarInfo() const {
    return model()->displayAsFrames() ?
        defaultFrameMenuBar : defaultChannelMenuBar;
}

