// diskstrings.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// The DiskString class stores the variable-length char strings for header
// attributes.

#ifndef DISKSTRINGS_H
#define DISKSTRINGS_H

#include <string.h>

class CompressionName {
	enum Len { StrLen = 64 };
protected:
	int lmin(int x, int y) const { return (x < y) ? x : y; }
	void copy(const char* string) {
		const int slen = lmin(strlen(string), StrLen);
		strncpy(charPtr(), string, slen);
		chars[0] = slen;  chars[slen + 1] = '\0';
	}
public:
	CompressionName() { copy("not compressed"); }
	CompressionName(const CompressionName& cname) { copy(cname.charPtr()); }
	const CompressionName& operator = (const char* string) {
		copy(string); return *this;
	}
	int operator == (const char* string) const {
		return (strncmp(charPtr(), string, lmin(strlen(string), StrLen)) == 0);
	}
	operator const char* () const { return chars; }
	int length() const { return int(chars[0]); }
private:
	char chars[StrLen + 1];
	char* charPtr() const { return (char *) (chars + 1); }
};

#endif
