// commandlookup.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// CommandLookups are contained as a member of the DataEditor class.
// Their purpose is to return a pointer to Modifier for any given KeySym, or
// nil if no command matches.

#ifndef COMMANDLOOKUP_H
#ifdef __GNUG__
#pragma interface
#endif
#define COMMANDLOOKUP_H

class DataEditor;
class Modifier;

struct CommandTableEntry {
	unsigned int keysym;
	Modifier* (*ctor)(DataEditor *);
};

class CommandLookup {
public:
	CommandLookup(DataEditor* editor) : theEditor(editor) {}
	Modifier* command(unsigned int keysym);
protected:
	Modifier* lookUpCommand(unsigned int keysym);
private:
	DataEditor* theEditor;
};

#endif
