// commandlookup.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#ifdef __GNUG__
#pragma implementation
#endif

#include "commandlookup.h"
#include "datamodifier.h"
#include "analysisfun.h"
#include "phraser.h"
#include "ellipfilt.h"
#include "fftfun.h"
#include "rescaler.h"
#include "interpolater.h"
#include "lowpassfilter.h"
#include "pulsegen.h"
#include "curvegen.h"
#include "crossfader.h"
#include <X11/keysym.h>

static CommandTableEntry dataEntries[] = {
	{ XK_r, Eraser::create },
	{ XK_y, Eraser::create },
	{ XK_e, Eraser::create },
	{ XK_x, OutSplicer::create },
	{ XK_X, OutSplicer::create },
	{ XK_d, OutSplicer::create },
	{ XK_m, Mixer::create },
	{ XK_R, Replacer::create },
	{ XK_g, Crossfader::create },
	{ XK_v, Splicer::create },
	{ 0L, nil }
};

Modifier *
CommandLookup::lookUpCommand(unsigned int keysym) {
	for(CommandTableEntry* entry = dataEntries; entry->keysym != 0L; entry++) {
		if(entry->keysym == keysym)
			return (entry->ctor) ? (*entry->ctor)(theEditor) : nil;
	}
	return nil;
}

Modifier *
CommandLookup::command(unsigned int keysym) {
	return lookUpCommand(keysym);
}
