// adjtext.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// base class for text input object whose value can be updated and displayed
// via the Adjust() method.  Max, min, and current values are set via a
// Perspective object.  Derived class definitions are here too:
// AdjustableNumber, AdjustableInteger, and AdjustableDouble
// See textinput.h for details on AdjustableText's base class

#ifndef ADJTEXT_H
#ifdef __GNUG__
#pragma interface
#endif
#define ADJTEXT_H

#include "localdefs.h"
#include "range.h"
#include "textinput.h"

class Perspective;

class AdjustableText : public TextInput {
	typedef TextInput Super;
public:
	AdjustableText(ButtonState *, const char *samp, QueryValue *);
    AdjustableText(const char* name, ButtonState *, const char *samp,
		QueryValue *);
	virtual ~AdjustableText();
	redefined void Reconfig();
	redefined void Adjust(Perspective &);
protected:
	int lower() const;
	int upper() const;
	int current() const;
	void setPerspectiveBounds(int lower, int upper);
	void setPerspectiveCurrent(int current);
	virtual void constrain(Perspective &);
	virtual void doAdjust(Perspective &) = 0;
private:
	void initialize();
};


// ********

class Range;

class AdjustableNumber : public AdjustableText {
public:
	AdjustableNumber(ButtonState *, const char *, QueryValue *);
	AdjustableNumber(const char*, ButtonState *, const char *, QueryValue *);	
	virtual void setBounds(const Range &)=0;
	virtual int integerValue()=0;
	virtual double doubleValue()=0;
};

// ********

class AdjustableInteger : public AdjustableNumber {
	typedef AdjustableNumber Super;
public:
	AdjustableInteger(ButtonState *, QueryValue *, const Range &);
	redefined void setBounds(const Range &);
	redefined int integerValue();
	redefined double doubleValue();
protected:
	redefined void doAdjust(Perspective &);
	redefined const char* stringValue();
	redefined int setCurrent(const char*);
private:
	void initialize(const Range&);
};

class AdjustableDouble : public AdjustableNumber {
	typedef AdjustableNumber Super;
public:
	AdjustableDouble(ButtonState *, QueryValue *, const Range &);
	redefined void setBounds(const Range &);
	redefined int integerValue();
	redefined double doubleValue();
protected:
	redefined void doAdjust(Perspective &);
	redefined const char* stringValue();
	redefined int setCurrent(const char*);
private:
	void initialize(const Range&);
	double fraction();
	Range valueRange;
};

#endif
