/*
 *   mwmpound.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporatio
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <stdio.h>
#include <string.h>

#include <mwmparse.h>
#include <mwmparsi.h>
#include <unidiags.h>

USHORT  mwmPoundCIDCommand(STATEINFO *psi);   /* move to mwmcidp.c */
USHORT  mwmPoundUDCommand(STATEINFO *psi);


/*****************************************************************************/
/* Routine to determine which Class 2 fax command has been issued.           */
/*****************************************************************************/
USHORT mwmPoundCommand(STATEINFO *psi)
{

  USHORT  usParserStatus = 0;
  USHORT  usCommandLength = 0;


 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundCommand entry\n");
  /***************************************************************************/
  /* Look at this character in AT Command.                                   */
  /* Then advance index to point to next character.                          */
  /***************************************************************************/
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"17=",strlen("17=")))
  {
    /*************************************************************************/
    /* This is a #17= command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("17=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"BDR=",strlen("BDR=")))
  {
    /*************************************************************************/
    /* This is a #BDR= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("BDR=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"CID=",strlen("CID=")))
  {
    /*************************************************************************/
    /* This is a #CID= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("CID=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmCidpCIDCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"CID?",strlen("CID?")))
  {
    /*************************************************************************/
    /* This is a #CID? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("CID?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmCidpCIDQuery(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"CLS=",strlen("CLS=")))
  {
    /*************************************************************************/
    /* This is a #CLS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("CLS=");
    psi->usNextATIndex += usCommandLength;
    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"CLS?",strlen("CLS?")))
  {
    /*************************************************************************/
    /* This is a #CLS?    command....                                        */
    /*************************************************************************/
    usCommandLength = strlen("CLS?");
    psi->usNextATIndex += usCommandLength;
    usParserStatus  = mwmPlusFCLASSQuestionCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"DVPS?",strlen("DVPS?")))
  {
    /*************************************************************************/
    /* This is a #DVPS? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("DVPS?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"MDL?",strlen("MDL?")))
  {
    /*************************************************************************/
    /* This is a #MDL? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("MDL?");
    psi->usNextATIndex += usCommandLength;
    usParserStatus = MWM_ATCMD_ERROR;
    usParserStatus  = mwmCmdI4Command(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"MFR?",strlen("MFR?")))
  {
    /*************************************************************************/
    /* This is a #MFR? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("MFR?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmClss2FMFRCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"REV?",strlen("REV?")))
  {
    /*************************************************************************/
    /* This is a #REV? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("REV?");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmClss2FREVCommand(psi);
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"SPK=",strlen("SPK=")))
  {
    /*************************************************************************/
    /* This is a #SPK= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("SPK=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"TL=",strlen("TL=")))
  {
    /*************************************************************************/
    /* This is a #TL= command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("TL=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VBS=",strlen("VBS=")))
  {
    /*************************************************************************/
    /* This is a #VBS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VBS=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VBT=",strlen("VBT=")))
  {
    /*************************************************************************/
    /* This is a #VBT= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VBT=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VCI?=",strlen("VCI?")))
  {
    /*************************************************************************/
    /* This is a #VCI? command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VCI?");
    psi->usNextATIndex += usCommandLength;
    usParserStatus = MWM_ATCMD_ERROR;
    /*************************************************************************/
    /* For now, do nothing.                                                  */
    /*************************************************************************/
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VLS=",strlen("VLS=")))
  {
    /*************************************************************************/
    /* This is a #VLS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VLS=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VRA=",strlen("VRA=")))
  {
    /*************************************************************************/
    /* This is a #VRA= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VRA=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VRN=",strlen("VRN=")))
  {
    /*************************************************************************/
    /* This is a #VRN= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VRN=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VRX",strlen("VRX")))
  {
    /*************************************************************************/
    /* This is a #VRX command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("VRX");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;

  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VSD=",strlen("VSD=")))
  {
    /*************************************************************************/
    /* This is a #VSD= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VSD=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VSK=",strlen("VSK=")))
  {
    /*************************************************************************/
    /* This is a #VSK= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VSK=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VTS=",strlen("VTS=")))
  {
    /*************************************************************************/
    /* This is a #VTS= command....                                           */
    /*************************************************************************/
    usCommandLength = strlen("VTS=");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"VTX",strlen("VTX")))
  {
    /*************************************************************************/
    /* This is a #VTX command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("VTX");
    psi->usNextATIndex += usCommandLength;

    usParserStatus = MWM_ATCMD_ERROR;
  }
  else
  if (!strncmp(&psi->achCommandBuffer[psi->usNextATIndex],"UD",strlen("UD")))
  {
    /*************************************************************************/
    /* This is a #UD  command....                                            */
    /*************************************************************************/
    usCommandLength = strlen("UD");
    psi->usNextATIndex += usCommandLength;

    usParserStatus  = mwmPoundUDCommand(psi);
  }
  else
    usParserStatus = MWM_ATCMD_ERROR;


  /***************************************************************************/
  /* If this command was valid (accepted by the parser)                      */
  /***************************************************************************/
  if (!usParserStatus)
  {
    /*************************************************************************/
    /* If we are pointing at whitespace or a semicolon,                      */
    /* move the pointer forward until we are past the whitespace and         */
    /* semicolons.                                                           */
    /*************************************************************************/
    while ((psi->achCommandBuffer[psi->usNextATIndex] == ' ') ||
           (psi->achCommandBuffer[psi->usNextATIndex] == ';'))
      psi->usNextATIndex++;
  }



  if (usParserStatus & MWM_GET_MORE_BUFFERS)
    /*************************************************************************/
    /* Move the AT Command Index back to this command to be parsed           */
    /* on the next interrupt.                                                */
    /*************************************************************************/
    psi->usNextATIndex-= usCommandLength;
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmpound::mwmPoundCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


/****************************************************************************
 *
 *  Unimodem diagnostics command
 *
 *  Modem diagnostics information is cleared on one of the following events
 *     1. Power off  (or D1 or D3 state entered)
 *     2. Hard reset (eg negate DTR with &D3 set)
 *     3. Soft reset = ATZ or AT&F
 *     4. ATD
 *     5. ATA
 *     6. automatic answer
 *  Not cleared by changing DTR, V.24 circuit 108.2, if not &D3
 *
 *  Output is in format:
 *
 *  DIAG <token key=value [[key=value] [key=value]] ...>
 *
 *  where token = 2A4D3263
 *
 *  This command is intended for use after calls. However, codes are defined so
 *  that a modem can respond before the 1st call is placed, and during a call
 *  for live monitoring purposes.
 *
 *
 ****************************************************************************/

BOOL MWM_ENTRY mwmPoundUDFillBuffer()
{
   USHORT usParserStatus = 0;
   UNIDIAG* pCS;
   int   j = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDFillBuffer entry\n");
   DPF("mwmPoundUDFillBuffer\n");

   memset( ud_buffer, 0, UD_BUFFER_SIZE );

   pCS = (UNIDIAG*) &psi->CallStatus;

   if (pCS)
   {
      const char szStartToken[] = "DIAG <2A4D3263";

      /*#define pBuf                  buffer+j, buffer_size-j*/
      #define pBuf                   (char*)ud_buffer+j
      #define DiagLineStart()        j+=sprintf(pBuf, "%s", szStartToken)
      #define DiagWORD(base,keynum)  if ( pCS->base.IsValid & BIT((0x ## keynum & 0xF)) ) \
                                       if (psi->bPoundUDDecimal) \
                                         j+=sprintf(pBuf, " %s=%u", #keynum, pCS->base.Key ## keynum);  \
                                       else \
                                         j+=sprintf(pBuf, " %s=%X", #keynum, pCS->base.Key ## keynum)
      #define DiagDWORD(base,keynum) if ( pCS->base.IsValid & BIT((0x ## keynum & 0xF)) )  \
                                       if (psi->bPoundUDDecimal) \
                                         j+=sprintf(pBuf, " %s=%lu", #keynum, pCS->base.Key ## keynum); \
                                       else \
                                         j+=sprintf(pBuf, " %s=%lX", #keynum, pCS->base.Key ## keynum) 
      #define DiagStr(base,keynum)   if ( pCS->base.IsValid & BIT((0x ## keynum & 0xF)) ) \
                                       j+=sprintf(pBuf, " %s=%s", #keynum, pCS->base.Key ## keynum)
      #define DiagLineEnd()          j+=sprintf(pBuf, ">"); j++

      /* temp*/
      /*pCS->Key0X.IsValid = 0xF;*/
      /*pCS->Key1X.IsValid = 0xF;*/
      /*pCS->Key2X.IsValid = 0xF;*/
      /*pCS->Key3X.IsValid = 0xF;*/
      /*pCS->Key4X.IsValid = 0xF;*/

      if ( pCS->Key0X.IsValid )
      {
         DiagLineStart();
         DiagStr(Key0X, 0);
         DiagWORD(Key0X, 1);
         DiagWORD(Key0X, 2);
         DiagWORD(Key0X, 3);
         DiagStr(Key0X, 4);
         DiagStr(Key0X, 5);
         DiagLineEnd();
      }

      if ( pCS->Key1X.IsValid )
      {
         DiagLineStart();
         DiagWORD(Key1X, 10);
         DiagWORD(Key1X, 11);
         DiagWORD(Key1X, 12);
         DiagWORD(Key1X, 13);
         DiagWORD(Key1X, 14);
         DiagWORD(Key1X, 15);
         DiagWORD(Key1X, 16);
         DiagWORD(Key1X, 17);
         DiagDWORD(Key1X, 18);
         DiagLineEnd();
      }

      if ( pCS->Key2X.IsValid )
      {
         DiagLineStart();
         DiagWORD(Key2X, 20);
         DiagWORD(Key2X, 21);
         DiagWORD(Key2X, 22);
         DiagWORD(Key2X, 23);
         DiagWORD(Key2X, 24);
         DiagWORD(Key2X, 25);
         DiagWORD(Key2X, 26);
         DiagWORD(Key2X, 27);
         DiagLineEnd();
      }

      if ( pCS->Key3X.IsValid )
      {
         DiagLineStart();
         DiagWORD(Key3X, 30);
         DiagWORD(Key3X, 31);
         DiagWORD(Key3X, 32);
         DiagWORD(Key3X, 33);
         DiagWORD(Key3X, 34);
         DiagWORD(Key3X, 35);
         DiagLineEnd();
      }

      if ( pCS->Key4X.IsValid )
      {
         DiagLineStart();
         DiagWORD(Key4X, 40);
         DiagWORD(Key4X, 41);
         DiagWORD(Key4X, 42);
         DiagWORD(Key4X, 43);
         DiagWORD(Key4X, 44);
         DiagWORD(Key4X, 45);
         DiagLineEnd();
      }

      if ( pCS->Key5X.IsValid )
      {
         if ( (pCS->Key5X.IsValid & 0xF ) )     /* split up into 3 lines*/
         {
            DiagLineStart();
            DiagWORD(Key5X, 50);
            DiagWORD(Key5X, 51);
            DiagDWORD(Key5X, 52);
            DiagDWORD(Key5X, 53);
            DiagLineEnd();
         }

         if ( (pCS->Key5X.IsValid & 0xF0 ) )
         {
            DiagLineStart();
            DiagDWORD(Key5X, 54);
            DiagDWORD(Key5X, 55);
            DiagDWORD(Key5X, 56);
            DiagDWORD(Key5X, 57);
            DiagLineEnd();
         }

         if ( (pCS->Key5X.IsValid & 0xF00 ) )
         {
            DiagLineStart();
            DiagDWORD(Key5X, 58);
            DiagDWORD(Key5X, 59);
            DiagLineEnd();
         }
      }

      if ( pCS->Key6X.IsValid )
      {
         DiagLineStart();
         DiagWORD(Key6X, 60);
         DiagWORD(Key6X, 61);
         DiagLineEnd();
      }

   }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmpound::mwmPoundUDFillBuffer exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

USHORT  mwmPoundUDEchoBuffer(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
  int    next_length;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDEchoBuffer entry\n");
  while (ud_buffer[ud_next])
  {
     DPF("mwmPoundUDEchoBuffer, ud_next = %d\n", ud_next);
     next_length = strlen(&ud_buffer[ud_next]);

     if (mwmParseEchoString(psi, (char*)&ud_buffer[ud_next]))  /* print a line to the UART*/
     {
        DPF("mwmPoundUDEchoBuffer, too long: %d\n", strlen(&ud_buffer[ud_next]));
        /*DPF("mwmPoundUDEchoBuffer, too long: %s\n", &ud_buffer[ud_next]);*/
        usParserStatus = MWM_GET_MORE_BUFFERS;     /* quit if PP_CMD buffer is full,*/
        psi->usCurrentCommand = MWM_PND_UD_CMD;    /*  and wait for PP cmds to be processed*/
        break;
     }

     ud_next += (next_length+1);                   /* skip to next line to be printed*/
  }
 MW_SYSLOG_2(TRACE_MWMPW32,"mwmpound::mwmPoundUDEchoBuffer exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}

BOOL MWM_ENTRY mwmPoundUDGetCallStatusBuffer(UNIDIAG* *pUniDiag)
{
   *pUniDiag = &psi->CallStatus;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDGetCallStatusBuffer entry+exit\n");
   return TRUE;
}

BOOL MWM_ENTRY mwmPoundUDClearCallStatus(BOOL bModemInit)
{
   KEY0X* pKey0X = &psi->CallStatus.Key0X;
   KEY6X* pKey6X = &psi->CallStatus.Key6X;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDClearCallStatus entry\n");
   memset( &psi->CallStatus, 0, sizeof(UNIDIAG) );

   strcpy( pKey0X->Key0, diag_Revision ); /* Diagnostic Command Specification revision number, digit.digit*/
   pKey0X->IsValid |= BIT(0);
/*   pKey0X->Key1 = 0;*/
/*   pKey0X->IsValid |= BIT(1);*/

   if (bModemInit) {
     pKey6X->Key60 = No_Previous_call;
   } else {
     pKey6X->Key60 = Call_is_still_in_progress;
   } /* endif */
   pKey6X->IsValid |= BIT(0);

 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDClearCallStatus exit TRUE\n");
   return TRUE;
}

USHORT  mwmPoundUDCommand(STATEINFO *psi)
{
  USHORT usParserStatus = 0;
 MW_SYSLOG_1(TRACE_MWMPW32,"mwmpound::mwmPoundUDCommand entry\n");
  ud_next = 0;

  if ( (psi->usNextPPIndex + 2) < PP_BUFFER_THRESHOLD)
  {
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = (0x24 | psi->usParserMode);
     psi->ausPPcmdBuffer[psi->usNextPPIndex++] = 92;
     psi->usCurrentCommand = MWM_PND_UD_CMD;
  }
  else
  {
    /*********************************************************************/
    /* There is not enough room left in this PP Command buffer to process*/
    /* this command....                                                  */
    /*********************************************************************/
    psi->usCurrentCommand = MWM_CONTINUE_AT_BUFFER;
  }

  usParserStatus = MWM_GET_MORE_BUFFERS;

 MW_SYSLOG_2(TRACE_MWMPW32,"mwmpound::mwmPoundUDCommand exit usParserStatus %x\n",usParserStatus);
  return usParserStatus;
}


