/*
 *   dspmgr.h -- Mwave Manager   
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*                                                                          */
/* NOTE: The achValid field used by each structure MUST be the first        */
/*       field of the structure.  Some code relies on this fact.            */
/*                                                                          */
/* NOTE: This file contains some elements that are required by the tool     */
/*       H2INC.  This tool creates a .INC file for ASM from a C-based H     */
/*       file.  It depends on some keywords that are contained in C         */
/*       comments as follows:                                               */
/*                                                                          */
/*       * XLATOFF and XLATON                                               */
/*       * Dummy comments after an opening bracket {                        */
/*                                                                          */
/* MULTILIST DATA STRUCTURE ORGANIZATION:                                   */
/*                                                                          */
/* Note that the lists used to hold the various segments, tasks, etc, are   */
/* all circular linked lists with a TAIL pointer into the list instead of   */
/* the usual HEAD pointer.  This allows instant access to both the Head AND */
/* Tail of the linked list.  Since preserving the original ordering of the  */
/* elements placed on the linked list is important, we will insert new      */
/* elements at the tail of the list.  In this way the linked list behaves   */
/* like a QUEUE and maintains a FIFO property.                              */
/*                                                                          */
/*                 Ŀ   Ŀ  */
/*                  Ŀ     Ŀ   Ŀ   Ŀ   Ŀ   */
/*                 > 1     > 1  > 2  > 3  > 4    */
/*                   <              <  */
/* Ŀ             Ŀ                                     Ŀ   */
/* Tail> NULL      Tail                                    Tail  */
/*                                                        */
/*                                                                          */
/*   DEPENDENCIES:                                                          */
/*                 DSPOS.H                                                  */
/*                                                                          */
/*   RESTRICTIONS: This file must NOT contains any operating system         */
/*                 specific code or structures.                             */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/*     DATE      NAME  CHANGE DESCRIPTION                                   */

/****************************************************************************/
/* STANDARD HUNGARIAN NOTATION                                              */
/* --------------------------------                                         */
/*                                                                          */
/*  ch      - char (1 byte)                                                 */
/*  s       - short (2 bytes)                                               */
/*  l       - long (4 bytes)                                                */
/*  i       - int (2 bytes on OS/2 and MS-DOS)                              */
/*  uch     - unsigned char                                                 */
/*  us      - unsigned short                                                */
/*  ul      - unsigned long                                                 */
/*  ui      - unsigned int                                                  */
/*  b       - byte                                                          */
/*  f       - boolean                                                       */
/*  p       - pointer                                                       */
/*  sz      - NULL terminated ASCII string (ASCIIZ)                         */
/*  psz     - far pointer to ASCIIZ                                         */
/*  npsz    - near pointer to ASCIIZ                                        */
/*  pch     - far pointer to char                                           */
/*  npch    - near pointer to char                                          */
/*  pfn     - far pointer to function                                       */
/*  npfn    - near pointer to function                                      */
/*  pb      - far pointer to byte                                           */
/*  pnb     - near pointer to byte                                          */
/*                                                                          */
/****************************************************************************/
/* ADDITIONAL HUNGARIAN NOTATION                                            */
/* -----------------------------                                            */
/*  r       - record (struct or union)                                      */
/*  pr      - pointer to record                                             */
/*  a       - generic array                                                 */
/*                                                                          */
/*  rver    - version structure                                             */
/*  rsl     - seglbl structure                                              */
/*  rmgr    - Manager structure                                             */
/*  rdsp    - DSP structure                                                 */
/*  rfm     - Frame manager structure                                       */
/*  rgpccl  - GPC connection list structure                                 */
/*  rmod    - Module structure                                              */
/*  rtsk    - Task structure                                                */
/*  rtsktmp - Temporary task structure                                      */
/*  rseg    - Segment structure                                             */
/*  rsegtmp - Temporary segment structure                                   */
/*  rmem    - Memory structure                                              */
/*  rimg    - Image structure                                               */
/*  rldma   - LDMA structure                                                */
/*  ripc    - IPC structure                                                 */
/*  rgpc    - GPC structure                                                 */
/*  arstbl  - Array of string table entries                                 */
/*  arpub   - Array of public structure                                     */
/*  arfix   - Array of fixup structures                                     */
/*  rhw     - Hardware structure                                            */
/*  rtcb    - Task Control Block structure                                  */
/*  rfmcb   - Frame Manager Control Block structure                         */
/*                                                                          */
/****************************************************************************/
/*  Global Typedefs                                                         */
/****************************************************************************/
#include "port_types.h"
extern USHORT cdbg;
#include "dspwin32.h"
#pragma pack(1)

#define FROMTOP 0            
#define FROMCURRENT  1       
#define  offsetof(s,m) (size_t)&(((s *)0)->m)

/* Set up files and macros for capturing embedded controller output */
/*   and API usage log output */
#define PRINT_DEBUG_FOPEN(file_ptr, file_name, file_mode, function_name) {}
#define PRINT_DEBUG_FCLOSE(file_ptr) {}
#define PRINT_DEBUG(fileptr, char_string, value) {}
#define PRINT_DEBUG_BIOS_WRITE(file_ptr, description_of_call, \
 carriage_cntl, num_printed, dsp_handle, dsp_addr, num_words, values)  {}

typedef struct rbiot    FAR *PRBIOT;   /* Ptr DMA structure                 */
typedef struct rfmcb    FAR *PRFMCB;   /* Ptr FMCB structure                */
typedef struct rg       FAR *PRG;      /* Ptr Global variables structure    */
typedef struct rgpccl   FAR *PRGPCCL;  /* Ptr GPC connection list struc     */
typedef struct rhw      FAR *PRHW;     /* Ptr HW structure                  */
typedef struct rhwdv    FAR *PRHWDV;   /* Ptr Hardware device structure     */
typedef struct rimg     FAR *PRIMG;    /* Ptr IMAGE structure (Temporary)   */
typedef struct ritcbcl  FAR *PRITCBCL; /* Ptr ITCB connection list struc    */
typedef struct ritcblab FAR *PRITCBLAB;/* Ptr ITCB Label structure          */
typedef struct rmem     FAR *PRMEM;    /* Ptr MEMORY structure              */
typedef struct rmgr     FAR *PRMGR;    /* Ptr Manager structure             */
typedef struct rsegtmp  FAR *PRSEGTMP; /* Ptr SEG structure (temp part)     */
typedef struct rtcb     FAR *PRTCB;    /* Ptr TCB structure                 */
typedef struct rtsktmp  FAR *PRTSKTMP; /* Ptr TASK structure (temp part)    */
typedef struct rtabentry FAR *PARSTBL; /* Ptr array of entries String Tab   */
typedef struct rpub     FAR *PARPUB;   /* Ptr array of PUB structures       */
typedef struct rfix     FAR *PARFIX;   /* Ptr array of Fixup structures     */
typedef PRMGR           HMGR;          /* Ptr MGR structure                 */
typedef PRHW            HHW;           /* Ptr HW structure                  */
typedef HHW             FAR *PHHW;     /* Ptr to Handle                     */

/****************************************************************************/
/* Constants for usFlags in API calls internal to Mwave Manager             */
/****************************************************************************/

#define  DSP_RELATIVE  0x0000          /* Return Relative address           */
#define  DSP_ABSOLUTE  0x0001          /* Return Absolute address           */
#define  DSP_LOAD_MASK 0x0009
#define  DSP_LOAD_FAILED 0x0008
#define  DSP_ACTIVATE_MASK 0x0003
#define  DSP_PRIORITY_MASK 0x0002
#define  DSP_PRIORITY_NONCRIT 0x0000
#define  DSP_PRIORITY_CRIT 0x0002

/****************************************************************************/
/* Binary sorted structure of segments under a module                       */
/****************************************************************************/

typedef struct bst FAR *PBST;          /* Ptr to binary tree structure      */

typedef struct bst {                   /* Binary segment tree structure     */
      HSEG       prSeg;                /* Segment handle                    */
      PBST       pbstLeftson;          /* Ptr to Segs names less than       */
      PBST       pbstRightson;         /* Ptr to Segs names more than       */
} BST;

typedef struct rseglbl { /**/
      PSZ        pszSegment;           /* Segment name                      */
      PSZ        pszLabel;             /* label name                        */
} RSEGLBL;

typedef struct ddinfo { /**/
      ULONG      pfnIDCEntry;          /* 16:16 Entry Address of BDD        */
      USHORT     usNumDSP;             /* # of ISPs supported by this BDD   */
} DDINFO;

/****************************************************************************/
/* HARDWARE DEVICE STRUCTURE                                                */
/* This structure identifies the HW tokens for HW devices                   */
/****************************************************************************/
typedef struct rhwdv { /**/
      PRHWDV     HWDV_prhwdvNext;      /* (CLL) Ptr to next Hardware Device */
} RHWDV;

/****************************************************************************/
/* PCMCIA Data cache structure                              CH19            */
/****************************************************************************/
typedef struct dc_ctl { /**/
  USHORT  DC_shift_ct;     /* how many bits to shift to find allocation */
  ULONG   DC_byte_ct;      /* EXACTLY how many USED bytes in the block  */
                           /* used to build exact PFT's.                */
                           /* Zero means the handle is unassigned       */
  HDSP    DC_hdsp;         /* dsp this handle is assigned to            */
  PFN     DC_lpfn;         /* user callback for this handle             */
/* dc transfer retry components assigned to this handle                 */
  BOOL    DC_retry;        /* flag - TRUE=retry schedule for this hdcb  */
  PVOID   DC_pTransferAddr;/* retry schedule user buffer address        */
  ULONG   DC_ulCacheAddr;  /* retry schedule cache address              */
  ULONG   DC_ulDataLen;    /* retry schedule data length                */
  USHORT  DC_usFlags;      /* retry schedule transfer direction         */
}DC_CTL;

/****************************************************************************/
/* Global variables structure                                               */
/****************************************************************************/

#define  DSPM_FAIL_INSTALL_MSG 7       /* Device driver failed to load      */
#define  NUMBASEPORTS  4               /* Number of BIOS DD Supported       */
#define  PACKETLENGTH  100             /* AS BIG AS LARGEST PACKET!         */
#define  BUFFLEN       260             /* AS BIG AS LARGEST PACKET!         */
                                       /* CH09 Removed QUERYLEN constant.   */
typedef struct rg { /**/
      PRMGR      prmgrTail;            /* (CLL) Root ptr to Managers        */
      PRMOD      prmodCurrentMod;      /* Points to Module that was last    */
                                       /* parsed. Used in fixup step.       */
      CHAR szErrorMsg[80];             /* space for ascii error msgs        */
      CHAR       szDetailErrorMsg[80]; /* space for ascii error msgs        */

      PVOID      pPermBaseAddr;        /* Permanent memory allocation ptr   */
      ULONG      ulPermCurSize;        /* Perm memory Current size          */
      ULONG      ulPermMaxSize;        /* Perm memory Total MAX size        */
      PVOID      pTempBaseAddr;        /* Temporary memory allocation ptr   */
      ULONG      ulTempMaxSize;        /* Temp memory Total MAX size        */
      HFILE      hDspmgrPDD;           /* File handle for Dsp Mgr PDD       */
      ULONG      hSemaphoreA;          /* Semaphore handle for Daemon       */
                                       /* request                           */
      USHORT     usDaemonFunc;         /* Daemon function request           */
      BYTE       DAEMONpacket[PACKETLENGTH];/* Parameter packet input for   */
                                       /* Daemon                            */
      PVOID      phvar;                /* Pointer to handle for variable    */
      BYTE       Buffer1[BUFFLEN];     /* Buffer 1                          */
      BYTE       Buffer2[BUFFLEN];     /* BUffer 2                          */
      BYTE       Buffer3[BUFFLEN];     /* BUffer 3                          */
                                       /* CH09 Removed querybuffer          */
      USHORT     usBufferSize;         /* USHORT variable                   */
      USHORT     usNum_BIOS_DD;        /* Number of BIOS Device Drivers     */
      DDINFO     BDDInfo[NUMBASEPORTS];/* IDC Entry Point per BIOS DD       */
      ULONG      ulPermAllocsPeak;     /* Used for debugging memory         */
      ULONG      ulPermAllocs;         /* allocation algorithms             */
      ULONG      ulPermAllocsSize;
      ULONG      ulTempAllocsPeak;
      ULONG      ulTempAllocs;
      ULONG      ulTempAllocsSize;
} RG;

/****************************************************************************/
/* Parameter Packet for Ring 3 IPC Thread                                   */
/****************************************************************************/

typedef struct threadparm { /**/
      USHORT     usIpcNum;             /* IPC mask                          */
      HANDLE     hDrv;                 /* handle to private DD open         */
      HANDLE     hThread;              /* handle to itself                  */
      PFN        pfnCallBack;          /* CallBackAddress                   */
} THREADPARM;

/****************************************************************************/
/* DSPM IDC Request Packet                                                  */
/****************************************************************************/

typedef struct rRP { /**/
      UCHAR      RP_ucLength;          /* Request packet length             */
      UCHAR      RP_ucUnit;            /* Unit Code (for block DD only)     */
      UCHAR      RP_ucCommand;         /* Command code                      */
      USHORT     RP_Status;            /* Packet Status                     */
      UCHAR      RP_ucRes[4];          /* Reserved bytes                    */
      ULONG      RP_ulQLink;           /* Queue linkage                     */
      UCHAR      RP_ucCategory;        /* Function Category                 */
      UCHAR      RP_ucCode;            /* Function Code                     */
      ULONG      RP_ulParm;            /* Parameter Buffer                  */
      ULONG      RP_ulData;            /* Data Buffer                       */
      ULONG      RP_usSysFile;         /* System File Number                */
} RRP;

typedef RRP *prRP;

/****************************************************************************/
/*                                                                          */
/* MANAGER STRUCTURE                                                        */
/*                                                                          */
/****************************************************************************/

#define  MGRVALIDATE   'MG'
typedef struct rmgr { /**/
      USHORT     MGR_achValid;
      USHORT     MGR_usID;             /* Manager ID (not used yet)         */
      PRMGR      MGR_prmgrNext;        /* (CLL) Ptr to next Manager         */
      PRDSP      MGR_prdspTail;        /* (CLL) Ptr to DSP's in this Mgr    */
      PRMOD      MGR_prmodTail;        /* (CLL) Ptr to Modules in this Mgr  */
      PRBIOT     MGR_prBiotTail;       /* (CLL) Ptr to BIOS Tasks in Mgr    */
      ULONG      MGR_ulBusCapacity;    /* User specified bus cap.           */
      ULONG      MGR_ulRemBusCapacity; /* Remaining bus capacity            */
} RMGR;

/****************************************************************************/
/*                                                                          */
/* DSP STRUCTURE                                                            */
/*                                                                          */
/****************************************************************************/

#define  DSPVALIDATE   'SP'

typedef struct rdsp { /**/
      USHORT     DSP_achValid;         /* validation of structure = 'SP'    */
      ULONG      DSP_DDEntry;          /* 16:16 BIOSDD IDC Entry point CH13 */
      ULONG      DSP_ulBIOSDD_ID;      /* BIOS DD's ISP identifier          */
      PRDSP      DSP_prdspNext;        /* (CLL) Ptr to next DSP in Mgr list */
      PRMGR      DSP_prmgr;            /* Ptr to parent manager             */
      ULONG      DSP_ulCPS;            /* Cycles Per Second of DSP chip     */
      ULONG      DSP_ulCPSFree;        /* Free CPS for this chip            */
      ULONG      DSP_ulIMemTotal;      /* Total Instruction Memory          */
      ULONG      DSP_ulDMemTotal;      /* Total Data Memory                 */
      HDSP       DSP_hDSPG;            /* Global Addr for this Struc        */
      HDSP       DSP_hDSP;             /* Non-Global Addr this Struc        */
      PRDSP      DSP_prdspNextG;       /* Global Ptr to next DSP            */

      /**********************************************************************/
      /* Ordered by address (lowest to highest)                             */
      /**********************************************************************/

      PRMEM      DSP_prmemDTail;       /* (CDLL) Tail of data seg list      */
      PRMEM      DSP_prmemITail;       /* (CDLL) Tail of code seg list      */

      /**********************************************************************/
      /* Ordered by size (smallest to largest)                              */
      /**********************************************************************/

      PRMEM      DSP_prmemDFreeTail;   /* (CDLL) Tail of FREE data seg list */
      PRMEM      DSP_prmemIFreeTail;   /* (CDLL) Tail of FREE code seg list */

      /**********************************************************************/
      /* Ordered by pure to impure ??????                                   */
      /**********************************************************************/

      PRMEM      DSP_prmemDUsedTail;   /* (CDLL) Tail of ALLOCATED data seg */
                                       /* list                              */
      PRMEM      DSP_prmemIUsedTail;   /* (CDLL) Tail of ALLOCATED code seg */
                                       /* list                              */
      PRFM       DSP_prfmTail;         /* (CDLL) Tail of FMCB list          */
      PRGPC      DSP_prgpcTail;        /* (CLL) Tail of system GPC List     */
      PRHW       DSP_prhwTail;         /* (CLL) Tail of system HW list      */
      PRIPCTE    DSP_prIPCTable;       /* IPC table                         */
      PRIPCTE    DSP_prIPCTableG;      /* Global IPC table address          */
      ULONG      DSP_ulMemXferDMAcb;   /* DSP address of DMA CB for MTX     */
      USHORT     DSP_usStatus;         /* Status of DSP.  Available?   CH15 */
      PVOID      DSP_pDataMem;         /* If no dsp, then will write to PC  */
                                       /* mem block                         */
      PVOID      DSP_pInstMem;         /* If no dsp, then will write to PC  */
                                       /* mem block                         */
      PRMOD      DSP_prmodOS;          /* OS Module ptr, used to get ISPOS  */
                                       /* labels for this DSP               */
      CHAR       DSP_ISPOS[10];        /* Name of this DSP's ISPOS          */
      RVER       DSP_rver;             /* Version of the DSP chip           */
      USHORT     DSP_usID;             /* ID of DSP (whichDSP)              */
      DC_CTL     *DSP_pDC_Ctl;         /* Ptr to PCMCIA data cache     CH19 */
      DC_CTL     *DSP_pDC_CtlG;        /* Global pointer to data cache CH19 */
} RDSP;

/****************************************************************************/
/* Equates for DSP_usStatus                                                 */
/****************************************************************************/
#define  DSP_STATUS_SUSPEND  0x0001    /* indicates DSP suspended      CH15 */

/****************************************************************************/
/* Equates for MIPS (CPS)                                                   */
/****************************************************************************/

#define  CPS_AV5       16000000L
#define  CPS_ISPOSOH   100000L
#define  CPS_SYSOH     100000L

/****************************************************************************/
/* Equates for CARD IDs                                                     */
/****************************************************************************/

#define  FP_CARD       0x8fe8          /* FREEPORT                          */
#define  FPFIN_CARD    0x8fe9          /* FREEPORT FINALE                   */
#define  FPENC_CARD    0x8fea          /* FREEPORT ENCORE                   */
#define  FPFUT_CARD    0x8feb          /* FREEPORT FUTURE                   */

/****************************************************************************/
/* IPC Table Entry.                                                         */
/****************************************************************************/

#define  IPCTEVALIDATE 'TE'
typedef struct ripcte { /**/
      USHORT     IPCTE_achValid;       /* validation of structure = 'TE'    */
      USHORT     IPCTE_usMask;         /* IPC Mask 0000-8000                */
      USHORT     IPCTE_usIntCount;     /* Pending interrupt count           */
      USHORT     IPCTE_usType;         /* Type of Callback                  */
      PRTSK      IPCTE_prtsk;          /* Task Containing the IPC.          */
      PFN        IPCTE_pfnCallBack;    /* Callback address.                 */
      PRIPCTE    IPCTE_pIPCChain;      /* Chain to next IPCTE (VDD)    CH07 */
      USHORT     IPCTE_usENVHandle;    /* Environment handle SessionID CH06 */
} RIPCTE;

/****************************************************************************/
/* Number of IPCs per DSP  16                                               */
/****************************************************************************/

#define  NUMIPC        0x0010

/****************************************************************************/
/* IPCTE_usType values                                                      */
/****************************************************************************/

#define  IPCTE_IDCCALL 0x00            /* Callback to a Ring 0 PDD          */
#define  IPCTE_RING3CALL 0x01          /* Callback to a Ring 3 Routine      */
#define  IPCTE_DOSCALL   0x02          /* Callback to OS/2 DOS Box     CH06 */
#define  IPCTE_WINCALL   0x03          /* Callback to WIN-OS/2 routine CH06 */
#define  IPCTE_VDDCALL   0x80          /* Callback to OS/2 VDDs        CH14 */

/****************************************************************************/
/*                                                                          */
/* FRAME MANAGER STRUCTURE                                                  */
/*                                                                          */
/****************************************************************************/

#define  FMVALIDATE    'FM'
typedef struct rfm { /**/
      USHORT     FM_achValid;          /* validation of structure = 'FM'    */
      USHORT     FM_usUseCount;        /* count of tasks using this FM      */
      PRFM       FM_prfmNext;          /* (CDLL) Ptr to next FM in the DSP  */
                                       /* linked-list                       */
      PRFM       FM_prfmPrev;          /* (CDLL) Ptr previous FM in the list*/
      PSZ        FM_pszName;           /* Name: for aperiodic grouping      */
      PRMEM      FM_prmemFMCB;         /* Ptr to DSP mem struct for FMCB    */
      PSZ        FM_pszHWintsource;    /* hardware interrupt source name    */
      HWID       FM_hwid;              /* hardware interrupt source         */
      ULONG      FM_ulSampleRate;      /* sample rate of this frame manager */
      USHORT     FM_usSamplesPerFrame; /* Samples per frame of this FM      */
      USFLG      FM_usflgType;         /* Frame Manager type                */
} RFM;

/****************************************************************************/
/* FM_usflgTYPE:                                                            */
/****************************************************************************/

#define  FM_TYPEMASK   0x00FF          /* FM type mask                      */
#define  FM_REALTIME   0x0000          /* Realtime task                     */
#define  FM_APERIODIC  0x0001          /* Aperiodic realtime task           */
#define  FM_NRT1       0x0002          /* Non-realtime task type 1          */
#define  FM_NRT2       0x0003          /* Non-realtime task type 2          */
#define  FM_OS         0x0004          /* OS tag                            */

/****************************************************************************/
/*                                                                          */
/* CONNECTION LIST STRUCTURE -  GPC's to be                                 */
/*                              connected later                             */
/****************************************************************************/

typedef struct rgpccl { /**/
      PRGPCCL    GPCCL_prgpcclNext;    /* Next set of GPC's to connect      */
      PSZ        GPCCL_pszGpc1FileName;/* Null = this file.                 */
      PSZ        GPCCL_pszGpc1ModName; /* Module Name                       */
      PSZ        GPCCL_pszGpc1TaskName;/* Task Name                         */
      PSZ        GPCCL_pszGpc1SegName; /* SegmentName                       */
      PSZ        GPCCL_pszGpc1GPCName; /* Name of GPC to be connected       */
      PSZ        GPCCL_pszGpc2FileName;/* Null = this file.                 */
      PSZ        GPCCL_pszGpc2ModName; /* Module Name                       */
      PSZ        GPCCL_pszGpc2TaskName;/* Task Name                         */
      PSZ        GPCCL_pszGpc2SegName; /* SegmentName                       */
      PSZ        GPCCL_pszGpc2GPCName; /* Name of GPC to be connected       */
      USHORT     GPCCL_usProtocol;     /* Protocol                          */
      PRGPC      GPCCL_prgpcUser;      /* Ptr to user GPC structure         */
      PRGPC      GPCCL_prgpcOwner;     /* Ptr to Owner GPC structure        */
} RGPCCL;

/****************************************************************************/
/* ITCB CONNECTION LIST STRUCTURE -  ITCB's to be connected later           */
/* This Block was redone for PhaseIII.                                      */
/****************************************************************************/

typedef struct ritcbcl { /**/
      PRITCBCL   ITCBCL_pritcbclNext;  /* Next set of ITCB's to connect     */
      PSZ        ITCBCL_pszITCBPFileName;/* Null = this file. FOR PRIMARY   */
      PSZ        ITCBCL_pszITCBPModName;/* Module Name                      */
      PSZ        ITCBCL_pszITCBPTaskName;/* Task Name                       */
      PSZ        ITCBCL_pszITCBPSegName;/* SegmentName                      */
      PSZ        ITCBCL_pszITCBPName;  /* Name of ITCB to be connected      */
      PSZ        ITCBCL_pszITCBSFileName;/* Null = this file. FOR PRIMARY   */
      PSZ        ITCBCL_pszITCBSModName;/* Module Name                      */
      PSZ        ITCBCL_pszITCBSTaskName;/* Task Name                       */
      PSZ        ITCBCL_pszITCBSSegName;/* SegmentName                      */
      PSZ        ITCBCL_pszITCBSName;  /* Name of ITCB to be connected      */
      PRITCB     ITCBCL_pritcbPrimary; /* Ptr to Primary ITCB structure     */
      PRITCB     ITCBCL_pritcbSecondary;/* Ptr to Secondary ITCB structure  */
} RITCBCL;

/****************************************************************************/
/*                                                                          */
/* MODULE STRUCTURE                                                         */
/*                                                                          */
/****************************************************************************/

#define  MODVALIDATE   'MD'
typedef struct rmod { /**/
      USHORT     MOD_achValid;         /* Validation of structure = 'MD'    */
      USFLG      MOD_usflgState;
      PRMOD      MOD_prmodNext;        /* (CLL) Ptr to next module          */
      PSZ        MOD_pszName;          /* Name of the module                */
      PRTSK      MOD_prtskTail;        /* (CLL) Ptr to tasks in this mod    */
      PRGPCCL    MOD_prgpcclTail;      /* (CLL) (tmp) Ptr to conn list of   */
                                       /* GPC's to allocated and conn during*/
                                       /* module load time                  */
      PRITCBCL   MOD_pritcbclTail;     /* ITCBCL list                       */
      USHORT     MOD_usNumDSSegs;      /* Nmber of DS segments for loadmod  */
      USHORT     MOD_usNumISSegs;      /* number of IS segments for loadmod */
      PBST       MOD_pbstDS;           /* root of DS Binary Seg tree        */
      PBST       MOD_pbstIS;           /* root of IS Binary Seg tree        */
      RVER       MOD_rver;             /* Revision level of the code        */
} RMOD;

/****************************************************************************/
/* MOD_usflgState:                                                          */
/****************************************************************************/

#define  MOD_STATEMASK 0x03            /* MOD_usflgState mask               */
#define  MOD_INACTIVE  0x00            /* Module in INACTIVE mode.          */
#define  MOD_STANDBY   0x01            /* Module in STANDBY mode            */
#define  MOD_ACTIVE    0x02            /* Module in ACTIVE mode.            */

/****************************************************************************/
/* Defines for usState in dspInit()                                         */
/****************************************************************************/

#define  DSP_INIT_INACTIVE 0x0000
#define  DSP_INIT_STANDBY 0x0001
#define  DSP_INIT_ACTIVE 0x0002

/****************************************************************************/
/*                                                                          */
/* TASK STRUCTURE                                                           */
/*                                                                          */
/****************************************************************************/

#define  TSKVALIDATE   'TK'
typedef struct rtsk { /**/
      USHORT     TSK_achValid;         /* Validation of structure = 'TK'    */
      USFLG      TSK_usflgType;        /* Flag: timer or Sample Rate        */
      PRTSK      TSK_prtskNext;        /* Ptr to next task in module space  */
      PSZ        TSK_pszVirtName;      /* Virtual name of this task         */
      PRMOD      TSK_prmod;            /* Ptr to parent module              */
      PRDSP      TSK_prdsp;            /* Ptr to parent DSP                 */
      PRSEG      TSK_prsegITail;       /* Ptr to Code Segments              */
      PRSEG      TSK_prsegDTail;       /* Ptr to Data Segments              */
      PRIPCTE    TSK_pripcte;          /* (CLL) Linked-list of IPCCB info   */
      PRSEG      TSK_prseg_IPC;        /* Segment where IPC is.             */
      ULONG      TSK_ulOffset_IPC;     /* offset of control block           */
      ULONG      TSK_ulCPF;            /* Cycles per frame                  */
      ULONG      TSK_ulCPS;            /* Cycles per Second (including ISPOS*/
                                       /* overhead)                         */
      PRFM       TSK_prfm;             /* Ptr to frame manager --or--       */
      PRHW       TSK_prhwTail;         /* HW this (BIOS) Task Drives        */
      PRLDMA     TSK_prldmaTail;       /* Linked-list of LDMACB info        */
      PRITCB     TSK_pritcbTail;       /* Linked-list of ITCB info          */
      PRGPC      TSK_prgpcTail;        /* Linked-list of GPC info           */
      PRTSKTMP   TSK_prtsktmp;         /* Ptr to temporary TASK structure   */
      USFLG      TSK_usflgState;       /* Current activation state of task  */
      RVER       TSK_rver;             /* Revision level of the code        */
} RTSK;

/****************************************************************************/
/* Temporary Task structure                                                 */
/****************************************************************************/

typedef struct rtsktmp { /**/
      RSEGLBL    TSK_rslActiveEntry;   /* Active Entry Point                */
      RSEGLBL    TSK_rslStandbyEntry;  /* Standby Entry Point               */
      RSEGLBL    TSK_rslALUEntry;      /* ALU Overflow Entry Point          */
      ULONG      TSK_ulTimeBase;       /* Sample rate of HW INT source      */
      USHORT     TSK_usSamplesPerFrame;/* Unused if Timer is given          */
      PSZ        TSK_pszRealName;      /* Real name task (virt name perm)   */
      PSZ        TSK_pszFileName;      /* Name of dsp file for task         */
      PSZ        TSK_pszFMGroupName;   /* FM group name for aperiodic FMs   */
      HWID       TSK_hwidHWIntSrc;     /* Source for time base (aic,cddac)  */
} RTSKTMP;

/****************************************************************************/
/* TSK_usflgType:                                                           */
/****************************************************************************/

#define  TSK_TYPEMASK  0x00FF          /* Task type mask                    */
#define  TSK_REALTIME  0x0000          /* Realtime task                     */
#define  TSK_APERIODIC 0x0001          /* Aperiodic realtime task           */
#define  TSK_NRT1      0x0002          /* Non-realtime task type 1          */
#define  TSK_NRT2      0x0003          /* Non-realtime task type 2          */
#define  TSK_OS        0x0004          /* OS tag                            */
#define  TSK_USEMASK   0xFF00          /* Usage mask                        */
#define  TSK_USESAMPLERATE 0x0000      /* Use sample rate                   */
#define  TSK_USETIMER  0x0100          /* Use timer inactive                */
#define  TSK_UNDEFINED 0x0200          /* Use is undefined                  */
#define  TSK_BIOSMASK  0x8000          /* BIOS mask                         */
#define  TSK_REGULAR   0x0000          /* Regular Task                      */
#define  TSK_BIOS      0x8000          /* BIOS Task                         */

/****************************************************************************/
/* TSK_usflgState:                                                          */
/****************************************************************************/

#define  TSK_INACTIVE  0x00            /* Task is inactive                  */
#define  TSK_STANDBY   0x01            /* Task is in standby mode           */
#define  TSK_ACTIVE    0x02            /* Task is in active mode            */
#define  TSK_STATEMASK 0x03            /* mask to check for activation      */

/****************************************************************************/
/*                                                                          */
/* SEGMENT STRUCTURE                                                        */
/*                                                                          */
/****************************************************************************/

#define  SEGVALIDATE   'SG'
typedef struct rseg { /**/
      USHORT     SEG_achValid;         /* validation of structure = 'SG'    */
      USFLG      SEG_usflg;            /* Segment flags                     */
      PRSEG      SEG_prsegNext;        /* (CLL) Ptr to next segment         */
      PSZ        SEG_pszVirtName;      /* Instance or null name             */
      PSZ        SEG_pszRealSegName;   /* Real name from the file           */
      PRTSK      SEG_prtsk;            /* Ptr to parent task                */
      PRMEM      SEG_prmem;            /* Independent part of segment       */
      PARSTBL    SEG_parstblStatic;    /* Nondiscardable string table       */
      ULONG      SEG_ulStaticSize;     /* Size of Static strin gtable       */
      PARPUB     SEG_parpub;           /* Public Label definitions          */
      ULONG      SEG_ulPubsSize;       /* Size of Public label definitions  */
      PRSEGTMP   SEG_prsegtmp;         /* Ptr to temporary SEG structure    */
      USHORT     SEG_usStaticCount;    /* Count of static string table      */
      USHORT     SEG_usPubsCount;      /* Count of definitions              */
      RVER       SEG_rver;             /* Revision level of code in segment */
      RVER       SEG_rverDSP;          /* DSP arch. seg was created for     */
} RSEG;

/****************************************************************************/
/* Temporary Segment structure                                              */
/****************************************************************************/

typedef struct rsegtmp { /**/
      PSZ        SEG_pszRealName;      /* Name of this segment              */
      PSZ        SEG_pszFileName;      /* FileName segment loaded from      */
      HFILE      SEG_hfile;            /* File handle for this segment      */
      ULONG      SEG_ulAlign;          /* Segment alignment in WORDs on DSP */
                                       /* memory (32 means dword boundary)  */
      ULONG      SEG_ulMemSize;        /* Dup of MEM_ulMemSize, because mem */
                                       /* structure hasn't been allocated   */
      ULONG      SEG_ulPrefix;         /* Prefix (used for TCB's in WORDs)  */
      PARSTBL    SEG_parstblDiscard;   /* Discardable string table          */
      USHORT     SEG_usDiscardCount;   /* Count of Discardable table        */
      ULONG      SEG_ulDiscardSize;    /* Size of Discardable table (Used to*/
                                       /* free table)                       */
      PARFIX     SEG_parfix;           /* Fixup label table                 */
      USHORT     SEG_usFixupCount;     /* Count of Fixup table              */
      ULONG      SEG_ulFixupSize;      /* Size of Fixup table (Used to free */
                                       /* table)                            */
      PRIMG      SEG_primgTail;        /* (CLL) Ptr to linked-list of binary*/
                                       /* images                            */
} RSEGTMP;

/****************************************************************************/
/* SEG_usflg:                                                               */
/****************************************************************************/

#define  SEG_PUREMASK  0x0001          /* PURE/IMPURE mask                  */
#define  SEG_PURE      0x0000          /* PURE =0                           */
#define  SEG_IMPURE    0x0001          /* IMPURE=1                          */
#define  SEG_REALMASK  0x0002          /* REAL/VIRTUAL mask                 */
#define  SEG_REAL      0x0000          /* REAL =0                           */
#define  SEG_VIRTUAL   0x0002          /* VIRTUAL=1                         */
#define  SEG_TYPEMASK  0x0020          /* SEGMENT TYPE mask                 */
#define  SEG_DDSMASK   0x0040          /* FREE DDS(Default Data Segment)    */
#define  SEG_DDS_INV   0x0040          /* Operation is not allowd =1        */
#define  SEG_DDS_OK    0x0000          /* Operation permitted =0            */
#define  SEG_DDS       0x0080          /* Marks segment as the DDS.         */
#define  SEG_GPC       0x0100          /* Seg contains GPC             CH20 */

/****************************************************************************/
/*                                                                          */
/* MEMORY STRUCTURE -  Independent segment structure                        */
/*                                                                          */
/****************************************************************************/

typedef struct rmem { /**/
      PRMEM      MEM_prmemNext;        /* (CDLL) Next in Memory list (by    */
                                       /* address)                          */
      PRMEM      MEM_prmemPrev;        /* (CDLL) Prev in Memory list        */
      PRMEM      MEM_prmemListNext;    /* (CDLL) Next in Alloc/Free list    */
      PRMEM      MEM_prmemListPrev;    /* (CDLL) Prev in Alloc/Free list    */
      USHORT     MEM_usUseCount;       /* number of segs using this memory  */
      ULONG      MEM_ulMemSize;        /* size of mem block in bytes        */
      ULONG      MEM_ulDspAddr;        /* DSP physical address of allocated */
                                       /* mem block (in bytes for data      */
                                       /* store/ in words for instructions  */
      ULONG      MEM_ulSegSize;        /* size of actual segment in words   */
      ULONG      MEM_ulSegAddr;        /* DspAddr + offset into allocated   */
                                       /* block. The actual Addr of start of*/
                                       /* segment. SegAddr only valid if MEM*/
                                       /* in Used chain                     */
} RMEM;

/****************************************************************************/
/* Flags for inhibiting the automatic freeing of Bios tasks when            */
/* disconnecting GPCs and ITCBs.                                            */
/****************************************************************************/
/* WARNING:                                                                 */
/*  the following flags are bit significant and will be ORed together       */
/*  when freeing of both the Owner and User is to be inhibited              */

#define  DONT_FREE_OWNER_BIOS  0x0001
#define  DONT_FREE_USER_BIOS   0x0002

/****************************************************************************/
/*                                                                          */
/* IMAGE STRUCTURE -  Actual binary images                                  */
/*                                                                          */
/****************************************************************************/

typedef struct rimg { /**/
      PRIMG      IMG_primgNext;        /* (CLL) Ptr to next IMG in linklist */
      ULONG      IMG_ulOffset;         /* Offset to load binary image.      */
      ULONG      IMG_ulSize;           /* Size of image in inst/data words  */
      PBYTE      IMG_pabData;          /* Ptr to actual binary image        */
      ULONG      IMG_ulFileOffset;     /* Offset in DSP file of binary image*/
} RIMG;

/****************************************************************************/
/*                                                                          */
/* DMA STRUCTURE for low-level DMA                                          */
/*                                                                          */
/****************************************************************************/

#define  LDMAVALIDATE  'LD'
typedef struct rldma { /**/
      USHORT     LDMA_achValid;        /* Validation of structure = 'LD'    */
      USFLG      LDMA_usflg;           /* DMA flags                         */
      PRLDMA     LDMA_prldmaNext;      /* (CLL) Ptr to next in LDMA list    */
                                       /* change from PRDMA to PRLDMA       */
      PSZ        LDMA_pszDMAName;      /* DMA name                          */
      LONG       LDMA_lPackets;        /* lDMA packet list packets          */
      ULONG      LDMA_ulMaxPkSize;     /* Maximum packet size               */
      LONG       LDMA_lMaxPerDMA;      /* Max DMA packets per frame         */
      ULONG      LDMA_ulOffset;        /* offset: stride/hold table index   */
      ULONG      LDMA_ulStride;        /* Stride distance                   */
      ULONG      LDMA_ulHold;          /* Hold value                        */
      PRSEG      LDMA_prseg;           /* Ptr to parent segment             */
      USHORT     LDMA_usSlotNum;       /* Stride/Hold slot number           */
} RLDMA;

/****************************************************************************/
/* LDMA_usflg:                                                              */
/****************************************************************************/

#define  LDMA_BUFMASK  0x0001          /* SHARABLE/NOTSHARABLE mask         */
#define  LDMA_SHARABLE 0x0001          /* Sharable buffer=1                 */
#define  LDMA_NOTSHARABLE 0x0000       /* Not =0                            */

/****************************************************************************/
/*                                                                          */
/* GPC STRUCTURE                                                            */
/*                                                                          */
/****************************************************************************/

#define  GPCVALIDATE   'GP'
typedef struct rgpc { /**/
      USHORT     GPC_achValid;         /* Validation of structure = 'GP'    */
      USFLG      GPC_usflgKind;        /* OWNER=0 USER=1 Vowner=2 Vuser=3   */
      PRGPC      GPC_prgpcNext;        /* (CLL) Ptr to Next in GPC list     */
      PSZ        GPC_pszName;          /* GPC name                          */
      LONG       GPC_lBufferSize;      /* GPC Buffer Size.                  */
      ULONG      GPC_ulOffset;         /* Offset of GPC CB, if virtual      */
                                       /* Offset of virtual list ptr        */
      ULONG      GPC_ulSamplerate;     /* Lower 32 bits of GPC type         */
      USHORT     GPC_usAddrMode;       /* GPC Address mode                  */
      USHORT     GPC_usMode;           /* GPC mode                          */
      USHORT     GPC_usMinPtrSep;      /* Min pointer separation            */
      USHORT     GPC_usMaxWPF;         /* Words per frame                   */
      USHORT     GPC_usIntegerStride;  /* Data words per sample period      */
      USHORT     GPC_usFractStride;    /* Fractional portion of stride      */
      LONG       GPC_lMaxdelay;        /* Maximum Delay                     */
      PRGPC      GPC_prgpcOwner;       /* Owner GPC. User GPC only          */
      PRGPC      GPC_prgpcUserListNext;/* User List                         */
      USHORT     GPC_usProtocol;       /* Connection Protocol               */
      USHORT     GPC_usUseCount;       /* # connects: Owner or Vuser        */
      PRMEM      GPC_prmemBuffer;      /* Ptr to DSP MEM for GPC buffer     */
      PRSEG      GPC_prseg;            /* Ptr to parent segment             */
      PRGPC      GPC_prvgpcTail;       /* (CLL) Ptr to tail of VGPC list    */
      ULONG      GPC_ulMaxCycles;      /* max num cycles per vgpc instance  */
      ULONG      GPC_ulVAllocSize;     /* words to alloc per vgpc instance  */
} RGPC;

/****************************************************************************/
/* GPC_usflgKind:                                                           */
/****************************************************************************/

#define  GPC_KINDMASK  0x0001          /* use to maskoff virtual bit        */
#define  GPC_VIRTMASK  0x0002          /* use to test virtual bit           */
#define  GPC_OWNER     0x0000          /* Owner GPC                         */
#define  GPC_USER      0x0001          /* User GPC                          */
#define  GPC_VIRTOWNER 0x0002          /* Virtual Owner GPC                 */
#define  GPC_VIRTUSER  0x0003          /* Virtual User GPC                  */

/****************************************************************************/
/* GPC_usAddrMode:                                                          */
/****************************************************************************/

#define  GPC_BYTE      0x0000          /* BYTE = 000                        */
#define  GPC_TABLE     0x0001          /* TABLE = 001                       */
#define  GPC_USHORT    0x0002          /* USHORT = 010                      */

/****************************************************************************/
/* GPC_usMode:                                                              */
/****************************************************************************/

#define  GPC_UNIVERSAL 0x0000          /* UNIVERSAL= 0000                   */
#define  GPC_OTHER     0xFFFF          /* OTHER = FFFF                      */

/****************************************************************************/
/* GPC_usProtocol:                                                          */
/****************************************************************************/

#define  GPC_UNDEFINED 0x0000          /* UNDEFINED= 0000                   */
#define  GPC_SYNC      0x0002          /* SYNC = 0002                       */
#define  GPC_OWNERDD   0x0004          /* OWNERDD = 0004                    */
#define  GPC_USERDD    0x0008          /* USERDD = 0008                     */
#define  GPC_SAFEDD    0x0010          /* SAFEDD = 0010                     */

/****************************************************************************/
/* VIRTUAL GPC STRUCTURE                                                    */
/*                                                                          */
/* VGPC shadows are now linked into the list of GPCs as well as             */
/* the list formed from prvgpcTail as follows:                              */
/*                                                                          */
/*          Ŀ  Ŀ  Ŀ  Ŀ  Ŀ                        */
/*          gpc->vgpc->shvgpc->shvgpc->gpc...                     */
/*               root->shadow<-shadow                             */
/*                A                          */
/*                                                               */
/*                                                                          */
/*          where gpc    = normal gpc                                       */
/*                vgpc   = root of vgpc                                     */
/*                shvgpc = shadow of root vgpc                              */
/*                                                                          */
/* Top pointers are regular gpc list pointers and bottom pointers           */
/* are VGPC list pointers kept in prvgpcTail element of RGPC                */
/* structure.  Removed old RVGPC structure definition.                      */
/****************************************************************************/

typedef struct vgpcinstance {          /* VGPC instance data structure      */
      USHORT     VGPCINS_usNextVGPC;
      USHORT     VGPCINS_usGain;
      USHORT     VGPCINS_usPutGetPtr;
      USHORT     VGPCINS_usSize;
      USHORT     VGPCINS_usMaxWPF;
      USHORT     VGPCINS_usPtrOtherPtr;
} RVGPCINS;

/****************************************************************************/
/*                                                                          */
/* GPC SYNC CONTROL BLOCK TEMPLATE                                          */
/*                                                                          */
/****************************************************************************/

typedef struct gpcsynctemplate { /**/
/* begin: MTS #3250 add dsp addr of ptrs to GPC ptrs to support Atomic sync */
      USHORT     usPtrOwnerPtrAddr;    /* address of user's ptr to owner ptr*/
      USHORT     usPtrUserPtrAddr;     /* address of owner's ptr to user ptr*/
/* end:   MTS #3250                                                                  */
      USHORT     usOwnerFM;            /* addr of owner frame mgr FCB       */
      USHORT     usUserFM;             /* addr of users frame mgr FCB       */
      USHORT     usMaxPtrSep;          /* max(user's,owner's) minimum ptr   */
                                       /* separation                        */
      USHORT     usIntegerStride;      /* Integer portion of stride         */
      USHORT     usFractStride;        /* Fractional portion of stride      */
      USHORT     usModMask;            /* modulo mask, bits within modulo   */
                                       /* range are 1's                     */
      USHORT     usOwnPtrAddr;         /* address of source's ptr (ownerptr)*/
      USHORT     usUserPtrAddr;        /* address of sink's pointer         */
                                       /* (userptr)                         */
      USHORT     usOwnAddMode;         /* source's addressing mode, 0 = byte*/
                                       /* addressing                        */
      USHORT     usUserAddMode;        /* sink's addressing mode, 0 = byte  */
                                       /* addressing                        */
      USHORT     usGpcAct;             /* = 1 initiates gpc synchronization */
} RGPCTMP;

typedef struct gpcsynctemplate *PRGPCTMP;

#define  GPCLABEL      "GPCSCB"        /* ISPOS label for GPC Sync Control  */
/* define control block label for Atomic Sync operation   MTS #3250         */
#define  GPCATOMICLABEL "GPCASCB" /* ISPOS label for GPC Atomic Sync Control*/

/****************************************************************************/
/*                                                                          */
/* ITCB STRUCTURE                                                           */
/*                                                                          */
/****************************************************************************/

#define  ITCBVALIDATE  'IT'
typedef struct ritcb { /**/
      USHORT     ITCB_achValid;        /* Validation of structure = 'IT'    */
      USFLG      ITCB_usflgKind;       /* Primary or Secondary              */
      PRITCB     ITCB_pritcbNext;      /* (CLL) Ptr to Next in ITCB list    */
      PSZ        ITCB_pszName;         /* ITCB name                         */
      ULONG      ITCB_ulSize;          /* ITCB Size                         */
      ULONG      ITCB_ulOffset;        /* Offset of CB in DSP dmem          */
      PRITCBLAB  ITCB_pritcblab;       /* ITCB Label definitions            */
      PRITCB     ITCB_pritcbPrimary;   /* Pointer to Primary ITCB           */
      PRITCB     ITCB_pritcbSecListNext;/* User List of Secondaries         */
      USHORT     ITCB_usLabelCount;    /* Count of definitions              */
      USHORT     ITCB_usUseCount;      /* # of Secondaries for Owner        */
      PRMEM      ITCB_prmemVariable;   /* Ptr to DSP MEM for Variable       */
      PRSEG      ITCB_prseg;           /* Ptr to parent segment             */
} RITCB;

/****************************************************************************/
/* ITCB_usflgKind:                                                          */
/****************************************************************************/

#define  ITCB_KINDMASK 0x0001          /* ITCB Kind Mask                    */
#define  ITCB_PRIMARY  0x0000          /* Primary ITCB                      */
#define  ITCB_SECONDARY 0x0001         /* Secondary ITCB                    */
#define  ITCB_NETWORKMASK 0x0010       /* ITCB Network Mask                 */
#define  ITCB_NETWORK  0x0010          /* Networking                        */
#define  ITCB_NONETWORK 0x0000         /* No Networking                     */

/****************************************************************************/
/*                                                                          */
/* ITCB Label STRUCTURE  -  Public label definition (This                   */
/*                          is a dynamically allocated                      */
/*                          structure array).                               */
/*                                                                          */
/****************************************************************************/

typedef struct ritcblab { /**/
      USHORT     ITCBLAB_usName;       /* index into static str table       */
      USHORT     ITCBLAB_usFlags;      /* Access Type flag                  */
      SHORT      ITCBLAB_sMaxdel;      /* >0 Use MaxDelt, <0 = -Maxdelf     */
} RITCBLAB;

/****************************************************************************/
/* ITCBLAB_usFlags: Access Flag for ITCB labels - Release 2.                */
/****************************************************************************/

#define  ITCB_ACCESSMASK  0x0005       /* Access Mask                       */
#define  ITCB_LABELWR     0x0000       /* Write/Read                        */
#define  ITCB_LABELRR     0x0001       /* Read/Read                         */
#define  ITCB_LABELRW     0x0002       /* Read/Write                        */
#define  ITCB_LABELWW     0x0003       /* Write/Write                       */
#define  ITCB_LABELPPONGP 0x0004       /* PingPong Secondary                */
#define  ITCB_LABELPPONGS 0x0005       /* PingPong Primary                  */

/****************************************************************************/
/*                                                                          */
/* STRING TABLE STRUCTURE -  Used for both static                           */
/*                           & discardable tables.                          */
/*                                                                          */
/****************************************************************************/

typedef struct rtabentry { /**/
      BYTE       bStrLen;              /* Length of the string, not inc NULL*/
      CHAR       chString;             /* Null-terminated string            */
} RTABENTRY;

/****************************************************************************/
/*                                                                          */
/* PUB STRUCTURE  -  Public label definition (This                          */
/*                   is a dynamically allocated                             */
/*                   structure array).                                      */
/*                                                                          */
/****************************************************************************/

typedef struct rpub {  /**/
      USHORT     PUB_usLabel;          /* index into static string table    */
      ULONG      PUB_ulOffset;         /* Offset into the segment of label  */
      USFLG      PUB_usflg;            /* Public/local flag                 */
} RPUB;

/****************************************************************************/
/* PUB_usflg:                                                               */
/****************************************************************************/

#define  PUB_PUBLICMASK 0x0003         /* PUBLIC/LOCAL/REF MASK             */
#define  PUB_PUBLIC    0x0000          /* PUBLIC = 0                        */
#define  PUB_LOCAL     0x0001          /* LOCAL = 1                         */
#define  PUB_REFERENCE 0x0002          /* REFERENCE = 2                     */
#define  PUB_EQUMASK   0x0004          /* EQUATE FLAG MASK                  */
#define  PUB_EQUATE    0x0004          /* EQUATE = 1                        */
#define  PUB_NOEQUATE  0x0000          /* NO EQUATE = 0                     */

/****************************************************************************/
/* FIXUP STRUCTURE -  (This is a dynamically allocated structure array).    */
/*                    This structure must NOT be reordered.  DSPPARSE       */
/*                    loads data directly from the DSP file into this       */
/*                    structure for speed.                                  */
/****************************************************************************/

typedef struct rfix { /**/
      USHORT     FIX_usFileName;       /* Index into strtab for Filename of */
                                       /* ref label                         */
      USHORT     FIX_usModName;        /* Index into strtab for Modname of  */
                                       /* ref label (assume 1 mod per file) */
      USHORT     FIX_usTaskName;       /* Index into strtab for Task of ref */
                                       /* label                             */
      USHORT     FIX_usSegment;        /* Index into strtab for Seg of ref  */
                                       /* label                             */
      USHORT     FIX_usLabel;          /* Index into Strtab for Referenced  */
                                       /* label                             */
      ULONG      FIX_ulOffset;         /* Offset of reference in segment    */
      ULFLG      FIX_ulflgType;        /* Fixup type                        */
      LONG       FIX_lLabOff;          /* Label offset - if valid = fixup   */
      LONG       FIX_lTextField;       /* The original address field        */
                                       /* contents                          */
      USFLG      FIX_usflg;            /* Fixup Flags                       */
} RFIX;

/****************************************************************************/
/* FIX_usflg:                                               CH03            */
/****************************************************************************/

#define  FIX_VALIDMASK   0x0001        /* VALID BIT                         */
#define  FIX_INVALID     0x0000        /* INVALID = 0 (override case)       */
#define  FIX_VALID       0x0001        /* VALID = 1 (modcomp filled Loff)   */
#define  FIX_DONEMASK    0x0002        /* FINISHED BIT                      */
#define  FIX_NOTFINISHED 0x0000        /* NONFINISHED=0 (work to be done)   */
#define  FIX_FINISHED    0x0002        /* FINISHED =1 (fixup finished)      */
#define  FIX_PUBEQUMASK  0x0004        /* PUBLIC EQUATE BIT                 */
#define  FIX_NOTPUBEQU   0x0000        /* NONPUBEQU =0 (symbol not pubequ)  */
#define  FIX_PUBEQU      0x0004        /* PUBEQU =1 (symbol is pubequ)      */

/****************************************************************************/
/* FIX_ulflgType                                            CH03            */
/****************************************************************************/

#define  FIX_SEGMENTMASK  0x8000
#define  FIX_INST         0x0000
#define  FIX_DATA         0x8000
#define  FIX_STYLEMASK    0x0700
#define  FIX_STYLE_OFFSET 0x0000
#define  FIX_STYLE_ABS    0x0100
#define  FIX_STYLE_ILR    0x0200
#define  FIX_STYLE_R4     0x0400
#define  FIX_CONTROLMASK  0x0007
#define  R4_BIT0          0x0001
#define  R4_BIT15         0x8000

/****************************************************************************/
/*                                                                          */
/* HARDWARE STRUCTURE                                                       */
/*                                                                          */
/****************************************************************************/

#define  HWVALIDATE    'HW'
typedef struct rhw { /**/
      PRHW       HW_prhwNext;          /* (CLL) Next in HW list             */
      PRTSK      HW_prtsk;             /* Owning BIOS Task                  */
      ULONG      HW_ulhwType;          /* HW Type                           */
} RHW;

#define  HW_ADC        0x0001          /* stereo line in                    */
#define  HW_AIC2       0x0006          /* phone line in                     */
#define  HW_MIDI       0x0008          /* MIDI                              */
#define  HW_CDDAC      0x8001          /* stereo line out                   */
#define  HW_AIC1       0xE006          /* phone line out                    */
#define  HW_UART       0xE00A          /* UART                              */
#define  HW_ACI        0xE00B          /* ACI                               */

/****************************************************************************/
/* Dsp File HW identifiers                                                  */
/****************************************************************************/

#define  DSPFILE_ACI   0x0004          /* Audio Control Interface           */
#define  DSPFILE_ADC   0x0003          /* stereo line in                    */
#define  DSPFILE_CDDAC 0x0000          /* stereo line out                   */
#define  DSPFILE_AIC2  0x0002          /* phone line in                     */
#define  DSPFILE_AIC1  0x0001          /* phone line out                    */
#define  DSPFILE_UART  0x8000          /* UART                              */
#define  DSPFILE_MIDI  0x8001          /* MIDI                              */

/****************************************************************************/
/*                                                                          */
/* BIOS STRUCTURE                                                           */
/*                                                                          */
/****************************************************************************/

typedef struct rbiot { /**/
      PRBIOT     BT_prBiotNext;        /* (CLL) Next                        */
      PSZ        BT_pszConnector;      /* Connector Name                    */
      PSZ        BT_pszTaskname;       /* TaskName Name                     */
      PSZ        BT_pszFilename;       /* FileName Name                     */
} RBIOT;

/****************************************************************************/
/*                                                                          */
/* TCB STRUCTURE -  Task control block                                      */
/*                                                                          */
/****************************************************************************/

typedef struct rtcb { /**/
      ULONG      TCB_ulCycles;         /* task's maximum cycle count        */
      USHORT     TCB_usAluReset;       /* pointer to ALU reset structure    */
      USHORT     TCB_usStandbyAddr;    /* standby code entry point          */
      USHORT     TCB_usMainAddr;       /* main code entry point             */
      USHORT     TCB_usRtnAddr;        /* ret addr to appropriate frame mgr */
      USHORT     TCB_usNextTCB;        /* pointer to next task control block*/
      USHORT     TCB_usCodePtr;        /* current entry point               */
} RTCB;

/* Negative offset from DefaultDataSeg to usNextTCB                         */

/* XLATOFF */
#define  TCB_NEXTTCB   offsetof(RTCB,TCB_usNextTCB)-sizeof(RTCB)
/* XLATON */

/****************************************************************************/
/*                                                                          */
/* FMCB STRUCTURE -  Frame manager control block                            */
/*                                                                          */
/****************************************************************************/

typedef struct rfmcb { /**/
      USHORT     FMCB_usZeros[3];      /* some zeros                        */
      USHORT     FMCB_usIntLink;       /* ptr to intr handlers data seg     */
      USHORT     FMCB_usMoreZeros[5];  /* more zeros                        */
      USHORT     FMCB_usFrameSize;     /* frame size                        */
      USHORT     FMCB_usFrameTime;     /* frame time                        */
      USHORT     FMCB_usOSRtn;         /* return to 'Scheduler'             */
      USHORT     FMCB_usFirstTCB;      /* init=addr of OSRtn-offset of      */
                                       /* codeptr                           */
      USHORT     FMCB_usISAddr;        /* addr of frame mgr code seg (FM)   */
      USHORT     FMCB_usLastZeros[19]; /* some more zeros                   */
      USHORT     FMCB_usSYSTMP0;
      USHORT     FMCB_usSYSTMP1;
      USHORT     FMCB_usSYSTMP2;
      USHORT     FMCB_usSYSTMP3;
      USHORT     FMCB_usSYSTMP4;
} RFMCB;

/* XLATOFF */
#define  FMCB_ISADDRESS offsetof(RFMCB,FMCB_usISAddr)
#define  FMCB_FIRSTTCB offsetof(RFMCB,FMCB_usFirstTCB)

/****************************************************************************/
/* SYSTEMPs defines                                                         */
/****************************************************************************/

#define  FMCB_SYSTEMP0 offsetof(RFMCB,FMCB_usSYSTMP0)
#define  FMCB_SYSTEMP1 offsetof(RFMCB,FMCB_usSYSTMP1)
#define  FMCB_SYSTEMP2 offsetof(RFMCB,FMCB_usSYSTMP2)
#define  FMCB_SYSTEMP3 offsetof(RFMCB,FMCB_usSYSTMP3)
#define  FMCB_SYSTEMP4 offsetof(RFMCB,FMCB_usSYSTMP4)
/* XLATON */

#ifdef   DSPMGR                        /* Used for DAEMON Main only         */
/****************************************************************************/
/*                                                                          */
/*  Global Variable Declarations: daemon declares storage, other reference  */
/*                                locations via extern.                     */
/*                                                                          */
/****************************************************************************/

char       pcMinus1[] =  {             /* Flag for unqualified labels.      */
      0xFF, 0xFF, 0x00                 /* Although it holds -1 followed by a*/
} ;                                    /* NULL terminator, it is Utreated as*/
                                       /* an ASCII string.                  */

char       pcMinus2[] =  {             /* Flag for ISPOS labels.            */
      0xFE, 0xFF, 0x00
} ;

char       pcMinus3[] =  {             /* Flag for Frame Mgr labels.        */
      0xFD, 0xFF, 0x00
} ;

PRG        pg;                         /* Pointer to global variables       */
PVOID      pPermBaseAddr;              /* Permanent memory allocation ptr   */
PVOID      pTempBaseAddr;              /* Temporary memory allocation ptr   */
BOOL       fDSPINIT_FLAG;              /* Global indicating init operation  */
USHORT     DEBUG_LEVEL;                /* Debug level flag                  */
CHAR       message[250];               /* Use for detailed messages         */

#else                                  /* else if not DAEMON Main code      */

/****************************************************************************/
/*                                                                          */
/*  Global Variable External References: (for all files other than daemon)  */
/*                                                                          */
/****************************************************************************/

extern   char pcMinus1[];              /* Flag for unqualified labels       */
extern   char pcMinus2[];              /* Flag for ISPOS labels             */
extern   char pcMinus3[];              /* Flag for Frame Manager labels     */
extern   PRG pg;                       /* Pointer to global                 */
extern   BOOL fDSPINIT_FLAG;           /* Global indicating init operation  */
extern   BOOL  fDOSOverlay;            /* Win Mgr overlaying DOS mgr mode   */
extern   BOOL  fInhibitDSPIO;          /* Inhibit DSP Writes, Run, Reset    */
extern   PRMEM prmemDSReserved;
extern   PRMEM prmemISReserved;
extern   USHORT DEBUG_LEVEL;           /* Debug level flag                  */
extern   CHAR message[250];            /* Use for detailed messages         */

#endif                                 /* End #ifdef DSPMGR                 */

#pragma pack()
