/*
 *   unidiags.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef unidiags_H
#define unidiags_H

/*const int diag_Revision = 8;       // 0.8 */
#define diag_Revision  "10"


/*
Table 5 - V.34 INFO bit report

bits    Source bits     Definition
31-30   INFO0 bit 20; 0
20-29   INFOc bits 79-88
16-19   INFOc bits 26-29 or 35-38 or 44-47 or 53-56- or 62-65 or 71-74  Pre-emphasis field, selected by the symbol rate chosen
12-15   INFOa bits 26-29
10-11   MP bit 50; 0
0-9     INFOa bits 40-49
*/

#define BIT(x)                (1<<x)

UINT shit;

typedef struct _V34INFO {                /* for key 18 */
       UINT INFOa_bits4049  :10;
       UINT MP_bit0         :1;
       UINT MP_bit50        :1;
       UINT INFOa_bits2629  :4;
       UINT INFOc_bits2629  :4; /* or 35-38 or 44-47 or 53-56- or 62-65 or 71-74 */
       UINT INFOc_bits7988  :10;
       UINT INFO0_bit0      :1;
       UINT INFO0_bit20     :1;
        } V34INFO;

/* see phase2dg.mwa infoc==info1c infoa==info1a mp = modulation parameter */


/*
Table 1 - AT#UD Last Call Status Report Format
Key     value(s)        Definition
0       2 digits        Diagnostic Command Specification revision number, digit.digit
1       Table 2 Call Setup Result code
2       Table 3 Multi-media mode
3       Table 4 DTE-DCE interface mode
4       String  V.8 CM octet string, same format as V.25ter Annex A, in quotes
5       String  V.8 JM octet string, same format as V.25ter Annex A, in quotes
6-F             reserved
10      2 digits        Received signal power level, in -dBm (0-43)
11      2 digits        Transmit signal power level, in -dBm (0-17)
12      2 digits        Estimated noise level, in -dBm (10-90)
13      2 digits        Normalized Mean Squared error, 100 (0x64) = minimum inter-symbol distance
14      2 digits        Near echo loss, in units of dB
15      2 digits        Far echo loss, in units of dB
16      4 digits        Far echo delay, in units of ms
17      2 digits        Round Trip delay, in units of ms
18      Table 5 V.34 INFO bit map
19-1F           reserved
20      Table 6 Transmit Carrier Negotiation Result
21      Table 6 Receive Carrier Negotiation Result
22      4 digits        Transmit Carrier symbol rate (0-8000)
23      4 digits        Receive Carrier symbol rate (0-8000)
24      4 digits        Transmit Carrier frequency (0-4000)
25      4 digits        Receive Carrier frequency  (0-4000)
26      4 digits        Initial transmit carrier data rate (0-64000)
27      4 digits        Initial receive carrier data rate (0-64000)
28-2F           reserved
30      2 digits        Temporary carrier loss event count
31      2 digits        Carrier Rate re-negotiation event count
32      2 digits        Carrier Retrains requested
33      2 digits        Carrier Retrain requests granted
34      4 digits        Final transmit carrier rate
35      4 digits        Final receive carrier rate
36-3F           reserved
40      Table 7 Protocol Negotiation Result
41      3 digits        Error Control frame size
42      2 digits        Error control link timeouts
43      2 digits        Error control link NAKs
44      Table 8 Compression Negotiation Result
45      4 digits        Compression dictionary size
46-4F           reserved
50      1 digit Transmit flow control: 0 = off; 1 = DC1/DC3; 2 = V.24 ckt 106/133
51      1 digit Receive flow control: 0 = off; 1 = DC1/DC3; 2 = V.24 ckt 106/133
52      8 digits        Transmit characters sent from DTE
53      8 digits        Received characters sent to DTE
54      8 digits        Transmit characters lost (data overrun errors from DTE)
55      8 digits        Received characters lost (data overrun errors to DTE)
56      8 digits        Transmit Frame count, if error control protocol running
57      8 digits        Received Frame count, if error control protocol running
58      8 digits        Transmit Frame error count, if error control protocol running
59      8 digits        Received Frame error count, if error control protocol running
5A-5F           Reserved
60      Tbls 9-10       Termination Cause
61      2 digits        Call Waiting event count
62-7F           Reserved
80-FF           Reserved for manufacturer proprietary keys
*/

typedef struct
{
     WORD   IsValid;
     char   Key0[3]; /* Diagnostic Command Specification revision number, digit.digit */
     WORD   Key1;   /* Table 2 Call Setup Result code */
     WORD   Key2;   /* Table 3 Multi-media mode */
     WORD   Key3;   /* Table 4 DTE-DCE interface mode */
     char   Key4[15]; /* V.8 CM octet string, same format as V.25ter Annex A, in quotes */
     char   Key5[15]; /* V.8 JM octet string, same format as V.25ter Annex A, in quotes */
} KEY0X;

typedef struct
{
     WORD   IsValid;
     WORD   Key10;  /* Received signal power level, in -dBm (0-43) */
     WORD   Key11;  /* Transmit signal power level, in -dBm (0-17) */
     WORD   Key12;  /* Estimated noise level, in -dBm (10-90) */
     WORD   Key13;  /* Normalized Mean Squared error, 100 (0x64) = minimum inter-symbol distance */
     WORD   Key14;  /* Near echo loss, in units of dB */
     WORD   Key15;  /* Far echo loss, in units of dB */
     WORD   Key16;  /* Far echo delay, in units of ms */
     WORD   Key17;  /* Round Trip delay, in units of ms */
     DWORD  Key18;  /* V34INFO // Table 5 V.34 INFO bit map */
                    /* Key19-1F           reserved */
} KEY1X;

typedef struct
{
     WORD   IsValid;
     WORD   Key20;  /* Table 6 Transmit Carrier Negotiation Result */
     WORD   Key21;  /* Table 6 Receive Carrier Negotiation Result */
     WORD   Key22;  /* Transmit Carrier symbol rate (0-8000) */
     WORD   Key23;  /* Receive Carrier symbol rate (0-8000) */
     WORD   Key24;  /* Transmit Carrier frequency (0-4000) */
     WORD   Key25;  /* Receive Carrier frequency  (0-4000) */
     WORD   Key26;  /* Initial transmit carrier data rate (0-64000) */
     WORD   Key27;  /* Initial receive carrier data rate (0-64000) */
                    /* Key28-2F           reserved */
} KEY2X;

typedef struct
{
     WORD   IsValid;
     WORD   Key30;  /* Temporary carrier loss event count */
     WORD   Key31;  /* Carrier Rate re-negotiation event count */
     WORD   Key32;  /* Carrier Retrains requested */
     WORD   Key33;  /* Carrier Retrain requests granted */
     WORD   Key34;  /* Final transmit carrier rate */
     WORD   Key35;  /* Final receive carrier rate */
                    /* Key36-3F           reserved */
} KEY3X;

typedef struct
{
     WORD   IsValid;
     WORD   Key40;  /* Table 7 Protocol Negotiation Result */
     WORD   Key41;  /* 3 digits Error Control frame size */
     WORD   Key42;  /* Error control link timeouts */
     WORD   Key43;  /* Error control link NAKs */
     WORD   Key44;  /* Table 8 Compression Negotiation Result */
     WORD   Key45;  /* Compression dictionary size */
                    /* Key46-4F           reserved */
} KEY4X;

typedef struct
{
     WORD   IsValid;
     WORD   Key50;  /* Transmit flow control: 0 = off; 1 = DC1/DC3; 2 = V.24 ckt 106/133 */
     WORD   Key51;  /* Receive flow control: 0 = off; 1 = DC1/DC3; 2 = V.24 ckt 106/133 */
     DWORD  Key52;  /* Transmit characters sent from DTE */
     DWORD  Key53;  /* Received characters sent to DTE */
     DWORD  Key54;  /* Transmit characters lost (data overrun errors from DTE) */
     DWORD  Key55;  /* Received characters lost (data overrun errors to DTE) */
     DWORD  Key56;  /* Transmit Frame count, if error control protocol running */
     DWORD  Key57;  /* Received Frame count, if error control protocol running */
     DWORD  Key58;  /* Transmit Frame error count, if error control protocol running */
     DWORD  Key59;  /* Received Frame error count, if error control protocol running */
                    /* Key5A-5F           Reserved */
} KEY5X;

typedef struct
{
     WORD   IsValid;
     WORD   Key60;  /* Tbls 9-10       Termination Cause */
     WORD   Key61;  /* Call Waiting event count */
} KEY6X;

/* Key62-7F           Reserved */
/* Key80-FF           Reserved for manufacturer proprietary keys */

typedef struct
{
     KEY0X   Key0X;
     KEY1X   Key1X;
     KEY2X   Key2X;
     KEY3X   Key3X;
     KEY4X   Key4X;
     KEY5X   Key5X;
     KEY6X   Key6X;
} UNIDIAG;


/*
Table 2 - Call Setup Result Codes

Code    Definition
0       No previous call (modem log has been cleared since any previous calls)
1       No dial tone detected
2       Reorder signal detected, network busy
3       Busy signal detected
4       No recognized signal detected
5       Voice detected
6       Text telephone signal detected (see V.18)
7       Data Answering signal detected (e.g. V.25 ANS, V.8 ANSam)
8       Data Calling signal detected (e.g. V.25 CT, V.8 CI)
9       Fax Answering signal detected (e.g. T.30 CED, DIS)
A       Fax Calling signal detected (e.g. T.30 CNG)
B       V.8bis signal detected
C-F     Reserved
*/
enum Key1 { No_previous_call,
            No_dial_tone,
            Reorder_signal,
            Busy_signal,
            No_recognized_signal,
            Voice,
            Text_telephone_signal,
            Data_Answering_signal,
            Data_Calling_signal,
            Fax_Answering_signal,
            Fax_Calling_signal,
            V_8bis_signal
          };



/*
Table 3 - Multimedia modes

Code    Definition
0       Data Only
1       FAX Only
2       Voice Only
3       VoiceView
4       ASVD, V.61
5       ASVD, "V.34Q"
6       DSVD, Multi-Tech
7       DSVD, 1.2
8       DSVD, V.70
9       Video-telephony, H.324
A       Other V.80 call
B-F     Reserved
*/
enum Key2 {
        Data_Only
       ,FAX_Only
       ,Voice_Only
       ,VoiceView
       ,ASVD_V_61
       ,ASVD_V_34Q
       ,DSVD_Multi_Tech
       ,DSVD_1_2
       ,DSVD_V_70
       ,Video_telephony_H324
       ,Other_V_80
        };

/*
Table 4 - DTE-DCE modes

Code    Definition
0       Async data
1       V.80 transparent synchronous mode
2       V.80 framed synchronous mode
3-F     Reserved
*/
enum Key3 {
        Async_data,
        V_80_transparent_synchronous,
        V_80_framed_synchronous_mode
        };

/*
Table 6 - gstnModulationSchemeActive from 3.7.2/V.58

Value (hex)     Description
0       V.17
1       V.21
2       V.22
3       V.22bis
4       V.23 CC
5       V.23 SC
6       V.26bis
7       V.26ter
8       V.27ter
9       V.29 HD
A       V.32
B       V.32bis
C       V.34
D       V.34 HD
E       V.pcm (asymmetric)
F       V.pcm (symmetric)
E-7F    Reserved (V.58)
80      "X2"
81      "K56FLEX"
82      "V.FC"
83      "V.32terbo"

80-FF   Reserved for mfgs
*/

enum Key20 {V_17,
            V_21,
            V_22,
            V_22bis,
            V_23_CC,
            V_23_SC,
            V_26bis,
            V_26ter,
            V_27ter,
            V_29_HD,
            V_32,
            V_32bis,
            V_34,
            V_34_HD,
            V_90,
            V_pcm_symmetric,

            X2 = 0x80,
            K56FLEX,
            V_FC,
            V_32terbo
            };

/*
Table 7 - errorControl Active from 3.5.2/V.58

Value   Description
0       Disable/none
1       V.42 LAPM
2       V.42 Alterative protocol (MNP)
3-7F    Reserved (V.58)
80      MNP10
81      ECP Enhanced Cellular Protocol
82-FF   Reserved for mfgs
*/
enum Key40 {No_Errorcontrol,
            V_42_LAPM,
            V_42_MNP,

            MNP10 = 0x80,
            ECP
            };



/*
Table 8 - compressionActive from 3.2.2/V.58

Value   Description
0       None
1       V.42bis
2-7F    Reserved (V.58)
80      MNP5
81-FF   Reserved for mfgs
*/
enum Key44 {No_Compression,
            V_42bis,

            MNP5 = 0x80,
            };

/*
Table 9 - Additional callCleared codes (3.6.4/V.58)

Code    Definition
1       No Previous call
2       Call is still in progress
3       Call Waiting signal detected
*/

/*
Table 10 - callCleared codes from 3.6.4/V.58-1994

callCleared: Indicates that the DCE has gone on hook and that the previously
existing network connection has been cleared.
These value are hex, converted from decimal in V.58.

Value   Description     Notes
0       CauseUnidentified       Call setup issues
1-3     See Table 3 above
A       NMSinitiatedDialCall    -- Network Management System
B       NMSinitiatedLeasedLineRestoral
C       NMSinitiatedRedial
D       NMSinitiatedDialDisconnect
14      PowerLoss       DCE
15      EquipmentFailure
16      FrontPanelDisconnectRequested
17      FrontPanelLeasedLineRestoral
18      AutomaticLeasedLineRestoral
19      InactivityTimerExpired
1E      cct116RestoralRequest   DTE Interface
1F      cct108isOffInhibitsDial
20      cct108turnedOff
28      NoNumberProvided        Line Interface
29      BlacklistedNumber
2A      CallAttemptsLimitExceeded
2B      ExtensionPhoneOffHook
2C      CallSetupFailTimerExpired
2D      IncomingCallDetected
2E      LoopCurrentInterrupted
2F      NoDialTone
30      VoiceDetected
31      ReorderTone
32      SitTone
33      EngagedTone
34      LongSpaceDisconnect
3C      CarrierLost     Signal Converter
3D      TrainingFailed
3E      NoModulationinCommon
3F      RetrainFailed
40      RetrainAttemptCountExceeded
41      GstnCleardownReceived
42      FaxDetected
46      InTestMode      Test
47      IntrusiveSelfTestInitiated
50      AnyKeyAbort     Call Control
51      DteHangupCommand
52      DteResetCommand
5A      FrameReject     Error Control
5B      NoErrorControlEstablished
5C      ProtocolViolation
5D      n400exceeded
5E      NegotiationFailed
5F      DisconnectFrameReceived
60      SabmeFrameReceived
64      LossOfSynchronization   Data Compression
*/

enum Key60 {
        CauseUnidentified
       ,No_Previous_call
       ,Call_is_still_in_progress
       ,Call_Waiting_signal_detected

       ,NMSinitiatedDialCall = 0xA              /* Network Management System */
       ,NMSinitiatedLeasedLineRestoral
       ,NMSinitiatedRedial
       ,NMSinitiatedDialDisconnect

       ,PowerLoss = 0x14                        /* DCE */
       ,EquipmentFailure
       ,FrontPanelDisconnectRequested
       ,FrontPanelLeasedLineRestoral
       ,AutomaticLeasedLineRestoral
       ,InactivityTimerExpired

       ,cct116RestoralRequest = 0x1E            /* DTE Interface */
       ,cct108isOffInhibitsDial
       ,cct108turnedOff

       ,NoNumberProvided = 0x28                 /* Line Interface */
       ,BlacklistedNumber
       ,CallAttemptsLimitExceeded
       ,ExtensionPhoneOffHook
       ,CallSetupFailTimerExpired
       ,IncomingCallDetected
       ,LoopCurrentInterrupted
       ,NoDialTone
       ,VoiceDetected
       ,ReorderTone
       ,SitTone
       ,EngagedTone
       ,LongSpaceDisconnect

       ,CarrierLost = 0x3C                      /* Signal Converter */
       ,TrainingFailed
       ,NoModulationinCommon
       ,RetrainFailed
       ,RetrainAttemptCountExceeded
       ,GstnCleardownReceived
       ,FaxDetected

       ,InTestMode = 0x46                       /* Test */
       ,IntrusiveSelfTestInitiated

       ,AnyKeyAbort = 0x50                      /* Call Control */
       ,DteHangupCommand
       ,DteResetCommand

       ,FrameReject = 0x5A                      /* Error Control */
       ,NoErrorControlEstablished
       ,ProtocolViolation
       ,n400exceeded
       ,NegotiationFailed
       ,DisconnectFrameReceived
       ,SabmeFrameReceived

       ,LossOfSynchronization = 0x64            /* Data Compression */
      };

#endif
