/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 mutella.h  -  common include file for the project

    begin                : Thu May 31 2001
    copyright            : (C) 2001 by
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
#ifndef __mutella_h_included__
#define __mutella_h_included__

/* AIX requires this to be the first thing in the file. */
#ifndef __GNUC__
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else /*HAVE_ALLOCA_H*/
#  ifdef _AIX
#   pragma alloca
#  else /*_AIX*/
#   ifndef alloca /* predefined by HP cc +Olibcalls */
     char *alloca ();
#   endif /*alloca*/
#  endif /*_AIX*/
# endif /*HAVE_ALLOCA_H*/
#else /*__GNUC__*/ /* not that I understand what I write here but it seems to be needed */
# if HAVE_ALLOCA_H
#  include <alloca.h>
# endif /*HAVE_ALLOCA_H*/
#endif /*__GNUC__*/

#ifdef __cplusplus

#include <memory>
#include <vector>
#include <string>
#include <list>

#ifdef HAVE_LIMITS
# include <limits>
#endif

#include <deque>
#include <queue>
#include <set>
#include <map>
#include <algorithm>
#include <iterator>

// declare namespaces
using std::min;
using std::max;
using std::swap;
//using std::queue;
//using std::deque;
using std::set;
using std::map;
using std::vector;
using std::list;
using std::insert_iterator;

#endif /*__cplusplus*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <errno.h>

// library-type includes
#include "defines.h"
#include "tstring.h"
#include "mthread.h"
//#include "asyncsocket.h"
#include "conversions.h"

// TODO: move these defines somewhere
#define MAX_TTL_ACCEPTED	15 // be very tolerant
#define MAX_TTL_SELF		7  // be reasonable
#define MAX_SHARE			31458312

#define CONNECT_TIMEOUT		10
#define NODECACHE_SIZE		200

// TODO: this is not the right place for it, really
// global variables
extern MMutex g_LibcMutex;
extern MMutex g_GetHostByNameMutex;
//#define g_GetHostByNameMutex g_LibcMutex

// application includes
//#include "common.h"
//#include "packet.h"
//#include "conversions.h"

#endif //__mutella_h_included__

