/***************************************************************************
                          gnusearch.cpp  -  description
                             -------------------
    begin                : Wed May 30 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <time.h>
#include "mutella.h"
#include "gnusearch.h"
#include "gnudirector.h"
#include "preferences.h"
#include "gnudownload.h"
#include "packet.h"

int  ResultGroup::SortBy = 0;
bool ResultGroup::Reverse = true;

MGnuSearch::MGnuSearch(MGnuDirector* pControl, const CString& search, int type, int size/*=0*/, int sizeMode/*=LIMIT_NONE*/)
{
	m_pDirector = pControl;
	m_Search   = StripWhite(search);
	m_nType = type;
	m_MinSpeed = 0;
	m_QueryID  = GUID_NULL;
	
	m_szSearch = new char[m_Search.length()+1];
	strcpy(m_szSearch, m_Search.c_str());
	MakeLower(m_szSearch);
	MakeWordList(m_szSearch, m_PlusWords, m_MinusWords);

	m_Packet = new BYTE[256];
	m_nPacketLength = 0;

	m_SizeFilterMode   = sizeMode;
	m_SizeFilterValue  = size;

	m_SpeedFilterMode  = LIMIT_NONE;
	m_SpeedFilterValue = 0;
	m_nHits = 0;
	m_bUpdated = false;	
	m_bAutoget = false;
	
	m_dwID = 0;
}

MGnuSearch::~MGnuSearch()
{
	delete [] m_Packet;
	delete [] m_szSearch;
}

void MGnuSearch::Clear()
{
	MLock lock(m_mutex);
	m_nHits = 0;
	m_GroupList.clear();
	m_CurrentList.clear();
}

void MGnuSearch::SendQuery()
{
	// Send query through network
	// but dont send queries smaller than 4 chars
	CString sQuery;
	int nWords = m_PlusWords.size();
	for (int i = 0; i<nWords; ++i)
	{
		sQuery += m_PlusWords[i];
		if (i+1<nWords)
			sQuery += " ";
	}
	if (sQuery.length()<4)
		return;
	int nSearchStlLen = min(sQuery.length(), 256-25-1);
	memcpy(m_Packet + 25, sQuery.c_str(), nSearchStlLen); //TODO: check bounds!!!
	m_Packet[25 + nSearchStlLen] = '\0'; //FIXED! out of bounds mem-write!
	m_nPacketLength = 25 + nSearchStlLen + 1;
	ASSERT(m_nPacketLength <=256 );

	m_QueryID = m_pDirector->Broadcast_LocalQuery(m_Packet, m_MinSpeed, m_nPacketLength);
}

bool MGnuSearch::IsFull()
{
	MLock lock(m_mutex);
	return m_CurrentList.size() >= m_pDirector->GetPrefs()->m_nMaxPerSearchResults;
}

bool MGnuSearch::CheckAgainstResult(const Result & result)
{
	// first check if we have this result already
	m_mutex.lock();
	int size = m_CurrentList.size();
	for (int i = 0; i<size; ++i)
	{
		if (result.Port        == m_CurrentList[i].Port        &&
		    result.FileIndex   == m_CurrentList[i].FileIndex   &&
		    result.Host.S_addr == m_CurrentList[i].Host.S_addr &&
		    result.NameLower   == m_CurrentList[i].NameLower   )
		{
			// we have a hit, but we are not going to add it again
			// we not only update its change time
			m_CurrentList[i].ChangeTime = time(NULL);
			// but also a GUID and Origin
			m_CurrentList[i].PushID = result.PushID;
			m_CurrentList[i].Origin = result.Origin;
			m_bUpdated = true;
			m_mutex.unlock();
			return true;
		}
	}
	m_mutex.unlock();
	if (size >= m_pDirector->GetPrefs()->m_nMaxPerSearchResults) // aka "IsFull"
		return false;// this search is full
	// Busy Filter
	if(m_pDirector->GetPrefs()->m_bScreenBusy)
		if(result.Busy)
			return false;
	// Node Filter
	if(m_pDirector->GetPrefs()->m_bSearchScreenNodes)
		return m_pDirector->CheckIP(result.Host);
	// Speed Filter
	if(m_SpeedFilterMode != LIMIT_NONE)
		if(!CheckLimit(m_SpeedFilterMode, m_SpeedFilterValue, result.Speed / 8))
			return false;
    // Size Filter
	if(m_SizeFilterMode != LIMIT_NONE)
	{
		if(!CheckLimit(m_SizeFilterMode, m_SizeFilterValue, result.Size))
			return false;
	}
	// Word Filter
	std::vector<CString>::iterator itWord;
	for (itWord = m_pDirector->GetPrefs()->m_ScreenedWords.begin(); itWord != m_pDirector->GetPrefs()->m_ScreenedWords.end(); itWord++)
		if(result.NameLower.find(*itWord) != -1)
			return false;

	// Name Check
	/*CString name = result.NameLower;
	if(!QueryMatch(name, m_Search))
		return false;*/
	
	// match against exclusive word list
	if (MatchWordList(result.NameLower, m_MinusWords, false))
		return false;
	// match against word list
	if (!MatchWordList(result.NameLower, m_PlusWords))
		return false;
	// now we have a definete hit
	m_nHits++;
	//
	m_mutex.lock();
	m_CurrentList.push_back(result);
	m_CurrentList.back().dwID = GenID();
	m_mutex.unlock();
	AddtoGroup(m_CurrentList.size()-1);
	m_bUpdated = true;
	return true;
}

/*int grpCompareNames(CString n1, CString n2)
{
	MakeLower(n1);
	MakeLower(n2);
	// get rid of directory
	ReplaceSubStr(n1,"\\","/");
	ReplaceSubStr(n2,"\\","/");
	n1 = n1.substr(n1.rfind("/")+1);
	n2 = n2.substr(n2.rfind("/")+1);
	ReplaceSubStr(n1,"_"," ");
	ReplaceSubStr(n2,"_"," ");
	ReplaceSubStr(n1,"."," ");
	ReplaceSubStr(n2,"."," ");
	return strcmp(n1.c_str(), n2.c_str());		
}*/

int grpCompareNames(CString n1, CString n2)
{
	return strcmp(MakeSearchOfFilename(n1).c_str(), MakeSearchOfFilename(n2).c_str());
}

ResultGroup* MGnuSearch::AddtoGroup(int nItem)
{
	MLock lock(m_mutex);
	MGnuPreferences* pPrefs = m_pDirector->GetPrefs();

	bool NewGroup = true;
	ResultGroup* ReturnGroup = NULL;

	// Check if item is part of any groups
	std::vector<ResultGroup>::iterator itGroup;

	if(pPrefs->m_bGroupbySize)
		for(itGroup = m_GroupList.begin(); itGroup != m_GroupList.end(); itGroup++)
			if((*itGroup).Size == m_CurrentList[nItem].Size)
			{
				if(pPrefs->m_bGroupbyName || pPrefs->m_bGroupbyFuzzyRules) //TODO: make fuzzy rules to work as appropriate
				{
					if(0 == grpCompareNames((*itGroup).Name, m_CurrentList[nItem].Name))
					{
						(*itGroup).ResultList.push_back(nItem);
						NewGroup = false;
						break;
					}
				}
				else
				{
					(*itGroup).ResultList.push_back(nItem);
					NewGroup = false;
					break;
				}
			}
	// If not create a new group
	if(NewGroup)
	{
		ResultGroup InsertGroup;

		InsertGroup.Name		= m_CurrentList[nItem].Name;
		InsertGroup.NameLower	= m_CurrentList[nItem].NameLower;
		InsertGroup.Size		= m_CurrentList[nItem].Size;
		InsertGroup.AvgSpeed	= m_CurrentList[nItem].Speed;

		InsertGroup.ResultList.push_back(nItem);

		m_GroupList.push_back(InsertGroup);
		m_GroupList.back().dwID = GenID();

		ReturnGroup = &m_GroupList.back();
	}
	else
	{
		// may be rename the group to mininun string length
		if ((*itGroup).Name.length()>m_CurrentList[nItem].Name.length())
			(*itGroup).Name=m_CurrentList[nItem].Name;
		// calc. avg. speed
		int Hosts = 0, SpeedSum = 0;
		std::vector<int>::iterator itResult;
		for(itResult = (*itGroup).ResultList.begin(); itResult != (*itGroup).ResultList.end(); itResult++)
		{
			SpeedSum += m_CurrentList[(*itResult)].Speed;
			Hosts++;
		}
		if(Hosts)
			(*itGroup).AvgSpeed = SpeedSum / Hosts;

		ReturnGroup = &(*itGroup);
	}

	return ReturnGroup;
}


/*bool MGnuSearch::Inspect(Result &Item)
{
	std::list<Result>::iterator itResult;
	
	CString Refine;
	m_tabResults->m_ebRefine.GetWindowText(Refine);

	// Refine filter
	if(Refine != "")
		if(!ResultDoubleCheck(Item.NameLower, Refine))
			return false;

	// If filtering is active
	if(m_tabResults->m_chkScreen.GetCheck())
	{
		// Busy Filter
		if(m_pPrefs->m_ScreenBusy)
			if(Item.Busy)
				return false;

		// Node Filter
		if(m_pPrefs->m_ScreenNodes)
			return m_pDoc->CheckIP(Item.Host);

		// Size Filter
		if(m_SizeFilterMode != LIMIT_NONE)
			if(m_FindingAlternates || m_FindingPartials)
			{
				if(!CheckLimit(m_SizeFilterMode, m_SizeFilterValue, Item.Size))
					return false;
			}
			else
			{
				if(!CheckLimit(m_SizeFilterMode, m_SizeFilterValue, Item.Size / 1024))
					return false;
			}
		// Speed Filter
		if(m_SpeedFilterMode != LIMIT_NONE)
			if(!CheckLimit(m_SpeedFilterMode, m_SpeedFilterValue, Item.Speed / 8))
				return false;

		// Word Filter
		std::vector<CString>::iterator itWord;
		for (itWord = m_pPrefs->m_ScreenedWords.begin(); itWord != m_pPrefs->m_ScreenedWords.end(); itWord++)
			if(Item.NameLower.Find(*itWord) != -1)
				return false;

		// Double Check
		if(m_pPrefs->m_DoubleCheck)
			if(!ResultDoubleCheck(Item.NameLower, m_Search))
				return false;
	}

	return true;
}*/

/*void MGnuSearch::SortList(int SubItem)
{
	if (ResultGroup::SortBy == SubItem)
	{
		ResultGroup::Reverse = !ResultGroup::Reverse;
	}
	else
	{
		ResultGroup::SortBy = SubItem;

		if(SubItem == 1 || SubItem == 3 || SubItem == 4)
			ResultGroup::Reverse = true;
		else
			ResultGroup::Reverse = false;
	}

	m_GroupList.sort();
}*/

bool MGnuSearch::CheckLimit(int Limit, DWORD Value, DWORD Compare)
{
	if(Limit == LIMIT_MORE)
	{
		if(Compare < Value)
			return false;
	}
	else if(Limit == LIMIT_EXACTLY)
	{
		if(Compare != Value)
			return false;
	}
	else if(Limit == LIMIT_LESS)
	{
		if(Compare > Value)
			return false;
	}

	return true;
}




