/*
 * Header of the GConf helper object.
 *
 * Music Applet
 * Copyright (C) 2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_CONF_H
#define MA_CONF_H

#include <glib-object.h>
#include <panel-applet.h>
#include <gconf/gconf-client.h>
#include <gtk/gtkcombobox.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkradiobutton.h>

#define MA_TYPE_CONF			(ma_conf_get_type ())
#define MA_CONF(o) 			(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_CONF, MaConf))
#define MA_CONF_CLASS(k) 		(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_CONF, MaConfClass))
#define MA_IS_CONF(o) 			(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_CONF))
#define MA_IS_CONF_CLASS(k) 		(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_CONF))
#define MA_CONF_GET_CLASS(o) 		(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_CONF, MaConfClass))

typedef struct _MaConf			MaConf;
typedef struct _MaConfClass		MaConfClass;

struct _MaConf
{
	GObject parent;
};

struct _MaConfClass
{
	GObjectClass parent_class;
};

GType ma_conf_get_type (void);

MaConf *ma_conf_new (PanelApplet *applet);

guint ma_conf_add_notify (MaConf *conf, const gchar *key, GConfClientNotifyFunc func, gpointer user_data);

gboolean ma_conf_get_bool (MaConf *conf, const gchar *key);
void ma_conf_bind_bool (MaConf *conf, const gchar *key, GtkCheckButton *button);

gchar *ma_conf_get_string (MaConf *conf, const gchar *key);
void ma_conf_bind_string_entry (MaConf *conf, const gchar *key, GtkEntry *entry);
void ma_conf_bind_string_combo_box (MaConf *conf, const gchar *key, GtkComboBox *combo_box, gint column);
void ma_conf_bind_string_radio (MaConf *conf, const gchar *key, const gchar *value, GtkRadioButton *button);
void ma_conf_bind_string_browse (MaConf *conf, const gchar *key, GtkButton *button);

#endif /* MA_CONF_H */
