//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: alsamidi.h,v 1.1.1.1 2003/10/29 10:06:12 wschweer Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __ALSAMIDI_H__
#define __ALSAMIDI_H__

// use autoconf configuration
#include <config.h>

#include <alsa/asoundlib.h>

#include "mididev.h"

extern int alsaSeqFd;
extern snd_seq_addr_t musePort;

//---------------------------------------------------------
//   MidiAlsaDevice
//---------------------------------------------------------

class MidiAlsaDevice : public MidiDevice {
   public:
      snd_seq_addr_t adr;

   private:
      int rwFlag;

      virtual QString open(int);
      virtual void close();
      virtual void processInput()  {}
      virtual int selectRfd()      { return -1; }
      virtual int selectWfd();

      void prepareEvent(snd_seq_event_t* event) {
            memset(event, 0, sizeof(event));
            event->queue   = SND_SEQ_QUEUE_DIRECT;
            event->source  = musePort;
            event->dest    = adr;
            }
      void putEvent(snd_seq_event_t*);

   public:
      MidiAlsaDevice() {}
      MidiAlsaDevice(const snd_seq_addr_t&, const QString& name);
      virtual ~MidiAlsaDevice() {}
      virtual void putEvent(const MidiPlayEvent*);
      virtual void putClock();
      virtual void putStart();
      virtual void putStop();
      virtual void putContinue();
      virtual void putSongpos(int);
      };

extern bool initMidiAlsa();
extern int alsaSelectRfd();
extern int alsaSelectWfd();
extern void alsaProcessMidiInput();
extern void alsaScanMidiPorts();
extern snd_seq_t* alsaSeq;

#endif


