//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: appearance.cpp,v 1.1.1.1 2003/10/29 10:05:06 wschweer Exp $
//=========================================================

#include <stdio.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qcolordialog.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qtoolbutton.h>
#include <qfontdialog.h>
#include <qapplication.h>
#include <qstylefactory.h>

#include "icons.h"
#include "appearance.h"
#include "track.h"
#include "app.h"
#include "song.h"
#include "event.h"
#include "arranger.h"
#include "widgets/filedialog.h"
#include "waveedit/waveedit.h"
#include "globals.h"

//---------------------------------------------------------
//   Appearance
//---------------------------------------------------------

Appearance::Appearance(Arranger* a, QWidget* parent, const char* name)
   : AppearanceDialogBase(parent, name)
      {
      arr = a;

	// ARRANGER

      currentBg = arr->bgPixmap();
      if (currentBg.isEmpty())
            currentBg = "<none>";
      currentBgLabel->setText(currentBg);

      int showPartEvent = arr->showPartEvent();
      int showPartType  = arr->showPartType();

      partShownames->setChecked(showPartType & 1);
      partShowevents->setChecked(showPartType & 2);
      partShowCakes->setChecked(!(showPartType & 2));

      eventNoteon->setChecked(		showPartEvent & (1 << 0));
      eventPolypressure->setChecked(	showPartEvent & (1 << 1));
      eventController->setChecked(	showPartEvent & (1 << 2));
      eventProgramchange->setChecked(	showPartEvent & (1 << 3));
      eventAftertouch->setChecked(	showPartEvent & (1 << 4));
      eventPitchbend->setChecked(	showPartEvent & (1 << 5));
      eventSpecial->setChecked(		showPartEvent & (1 << 6));
      eventButtonGroup->setEnabled(showPartType == 2);
      arrGrid->setChecked(arr->hasGrid());

	// COLORS

      // 0
//      color[itemListBox->count()] = arr->getSelectedTrackColor();
//      itemListBox->insertItem(tr("selected tracks in arranger"));

      // 1
      color[itemListBox->count()] = muse->getTransportHandleColor();
      itemListBox->insertItem(tr("handle of transport window"));

      // 2
      color[itemListBox->count()] = arr->getActivityColor();
      itemListBox->insertItem(tr("track activity in arranger"));

      // 3
      color[itemListBox->count()] = muse->getBigTimeForegroundColor();
      itemListBox->insertItem(tr("bigtime font color"));

      // 4
      color[itemListBox->count()] = muse->getBigTimeBackgroundColor();
      itemListBox->insertItem(tr("bigtime background color"));

      // 5
      color[itemListBox->count()] = WaveEdit::configBg();
      itemListBox->insertItem(tr("waveedit background color"));

	/* more to come i hope... */


      colorSelectedGroupBox->setEnabled(false);

      useDynamicColors->setChecked(arr->getActivityMode() == 1);

      connect(itemListBox, SIGNAL(selectionChanged()), SLOT(colorItemSelectionChanged()));
      connect(colorSelectButton, SIGNAL(clicked()), SLOT(configColor()));

	// STYLE

      themeComboBox->clear();
      themeComboBox->insertStringList(QStyleFactory::keys());
      for(int i = 0; i < themeComboBox->count(); ++i)
            if (themeComboBox->text(i) == muse->currentTheme())
                  themeComboBox->setCurrentItem(i);

      //---------------------------------------------------
	//    Fonts
      //---------------------------------------------------

      lfont[0] = font0;
      lfont[1] = font1;
      lfont[2] = font2;
      lfont[3] = font3;
      lfont[4] = font4;
      lfont[5] = font5;

      fontBrowse0->setPixmap(*openIcon);
      fontBrowse1->setPixmap(*openIcon);
      fontBrowse2->setPixmap(*openIcon);
      fontBrowse3->setPixmap(*openIcon);
      fontBrowse4->setPixmap(*openIcon);
      updateFonts();
      connect(fontBrowse0, SIGNAL(clicked()), SLOT(browseFont0()));
      connect(fontBrowse1, SIGNAL(clicked()), SLOT(browseFont1()));
      connect(fontBrowse2, SIGNAL(clicked()), SLOT(browseFont2()));
      connect(fontBrowse3, SIGNAL(clicked()), SLOT(browseFont3()));
      connect(fontBrowse4, SIGNAL(clicked()), SLOT(browseFont4()));
      connect(fontBrowse5, SIGNAL(clicked()), SLOT(browseFont5()));

      connect(applyButton, SIGNAL(clicked()), SLOT(apply()));
      connect(okButton, SIGNAL(clicked()), SLOT(ok()));
      connect(cancelButton, SIGNAL(clicked()), SLOT(cancel()));
      connect(selectBgButton, SIGNAL(clicked()), SLOT(configBackground()));
      connect(partShowevents, SIGNAL(toggled(bool)), eventButtonGroup, SLOT(setEnabled(bool)));
      }

//---------------------------------------------------------
//   updateFonts
//---------------------------------------------------------

void Appearance::updateFonts()
      {
      fontSize0->setValue(lfont[0].pointSize());
      fontName0->setText(lfont[0].family());
      italic0->setChecked(lfont[0].italic());
      bold0->setChecked(lfont[0].bold());

      fontSize1->setValue(lfont[1].pointSize());
      fontName1->setText(lfont[1].family());
      italic1->setChecked(lfont[1].italic());
      bold1->setChecked(lfont[1].bold());

      fontSize2->setValue(lfont[2].pointSize());
      fontName2->setText(lfont[2].family());
      italic2->setChecked(lfont[2].italic());
      bold2->setChecked(lfont[2].bold());

      fontSize3->setValue(lfont[3].pointSize());
      fontName3->setText(lfont[3].family());
      italic3->setChecked(lfont[3].italic());
      bold3->setChecked(lfont[3].bold());

      fontSize4->setValue(lfont[4].pointSize());
      fontName4->setText(lfont[4].family());
      italic4->setChecked(lfont[4].italic());
      bold4->setChecked(lfont[4].bold());

      fontSize5->setValue(lfont[5].pointSize());
      fontName5->setText(lfont[5].family());
      italic5->setChecked(lfont[5].italic());
      bold5->setChecked(lfont[5].bold());
      }

//---------------------------------------------------------
//   apply
//---------------------------------------------------------

void Appearance::apply()
      {
	int showPartEvent = 0;
	int showPartType = 0;

	if (partShownames->isChecked())		
            showPartType  |= 1;
	if (partShowevents->isChecked())		
            showPartType  |= 2;
 	if (partShowCakes->isChecked())		
            showPartType  |= 4;

	if (eventNoteon->isChecked())		
            showPartEvent |= (1 << 0);
	if (eventPolypressure->isChecked())	
            showPartEvent |= (1 << 1);
	if (eventController->isChecked())	
            showPartEvent |= (1 << 2);
	if (eventProgramchange->isChecked())	
            showPartEvent |= (1 << 3);
	if (eventAftertouch->isChecked())	
            showPartEvent |= (1 << 4);
	if (eventPitchbend->isChecked())		
            showPartEvent |= (1 << 5);
	if (eventSpecial->isChecked())		
            showPartEvent |= (1 << 6);

      arr->setBgPixmap(currentBg);
	arr->setShowPartType(showPartType);
	arr->setShowPartEvent(showPartEvent);
      arr->setGrid(arrGrid->isChecked());

      lfont[0].setPointSize(fontSize0->value());
      lfont[0].setItalic(italic0->isChecked());
      lfont[0].setBold(bold0->isChecked());
      font0 = lfont[0];
	QApplication::setFont(font0, true);

      lfont[1].setPointSize(fontSize1->value());
      lfont[1].setItalic(italic1->isChecked());
      lfont[1].setBold(bold1->isChecked());
      font1 = lfont[1];

      lfont[2].setPointSize(fontSize2->value());
      lfont[2].setItalic(italic2->isChecked());
      lfont[2].setBold(bold2->isChecked());
      font2 = lfont[2];

      lfont[3].setPointSize(fontSize3->value());
      lfont[3].setItalic(italic3->isChecked());
      lfont[3].setBold(bold3->isChecked());
      font3 = lfont[3];

      lfont[4].setPointSize(fontSize4->value());
      lfont[4].setItalic(italic4->isChecked());
      lfont[4].setBold(bold4->isChecked());
      font4 = lfont[4];

      lfont[5].setPointSize(fontSize5->value());
      lfont[5].setItalic(italic5->isChecked());
      lfont[5].setBold(bold5->isChecked());
      font5 = lfont[5];

	muse->loadTheme(themeComboBox->currentText());
	// setting up a new theme might change the fontsize, so re-read
      fontSize0->setValue(QApplication::font().pointSize());

	// set colors...
  //    arr->setSelectedTrackColor(color[0]);
	muse->setTransportHandleColor(color[0]);
	arr->setActivityColor(color[1]);
	muse->setBigTimeForegroundColor(color[2]);
	muse->setBigTimeBackgroundColor(color[3]);
      WaveEdit::setConfigBg(color[4]);
      muse->configChanged();
	
	arr->setActivityMode(useDynamicColors->isChecked()?1:0);
      song->appearanceChanged();
      }

//---------------------------------------------------------
//   ok
//---------------------------------------------------------

void Appearance::ok()
      {
      apply();
      close(false);
      }

//---------------------------------------------------------
//   cancel
//---------------------------------------------------------

void Appearance::cancel()
      {
      close(false);
      }

//---------------------------------------------------------
//   configBackground
//---------------------------------------------------------

void Appearance::configBackground()
      {
      QString cur(currentBg);
      if (cur == "<none>")
            cur = museGlobalShare + "/wallpapers";
      currentBg = getImageFileName(cur, image_file_pattern, this,
         tr("MusE: load image"));
      if (currentBg.isEmpty())
            currentBg = "<none>";
      currentBgLabel->setText(currentBg);
      }

//---------------------------------------------------------
//    selectionChanged
//---------------------------------------------------------

void Appearance::colorItemSelectionChanged()
      {
      int n = itemListBox->currentItem();
      bool b = (itemListBox->currentText() != "");
      colorFrame->setBackgroundColor(color[n]);
      colorSelectedGroupBox->setEnabled(b);
      }

//---------------------------------------------------------
//   configColor
//---------------------------------------------------------

void Appearance::configColor()
      {
      int n = itemListBox->currentItem();
      color[n] = QColorDialog::getColor( color[n], this );
      colorFrame->setBackgroundColor(color[n]);
      }

//---------------------------------------------------------
//   browseFont
//---------------------------------------------------------

void Appearance::browseFont0() { browseFont(0); }
void Appearance::browseFont1() { browseFont(1); }
void Appearance::browseFont2() { browseFont(2); }
void Appearance::browseFont3() { browseFont(3); }
void Appearance::browseFont4() { browseFont(4); }
void Appearance::browseFont5() { browseFont(5); }

void Appearance::browseFont(int n)
      {
      bool ok;
      QFont font = QFontDialog::getFont(&ok, lfont[n], this, "browseFont");
      if (ok) {
            lfont[n] = font;
            updateFonts();
            }
      }

