//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: sliderbase.h,v 1.2 2001/11/20 15:19:35 muse Exp $

//    Copyright (C) 1997  Josef Wilgen
//	This program is free software; you can redistribute it and/or modify
//	it under the terms of the GNU General Public License, version 2,
//	as published by	the Free Software Foundation.
//
//    (C) Copyright 1999 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __SLIDERBASE_H__
#define __SLIDERBASE_H__

#include "drange.h"
#include <qframe.h>
#include <qpixmap.h>
#include <qdatetm.h>


//---------------------------------------------------------
//   SliderBase
//---------------------------------------------------------

class SliderBase : public QWidget, public DoubleRange
      {
	Q_OBJECT

	int d_tmrID;
	int d_updTime;
	int d_timerTick;
	QTime d_time;
	double d_speed;
	double d_mass;

	void buttonReleased();

 protected:
	int d_scrollMode;
	double d_mouseOffset;
	int d_direction;
	int d_tracking;
	                  
	virtual void setMass(double val);
	void setPosition(const QPoint &p);
	virtual void valueChange();
	virtual double mass() const { return d_mass; }

	void timerEvent(QTimerEvent *e);
	void mousePressEvent(QMouseEvent *e);
	void mouseReleaseEvent(QMouseEvent *e);
	void mouseMoveEvent(QMouseEvent *e);
	virtual double getValue(const QPoint & p) = 0;
	virtual void getScrollMode( const QPoint &p,
				   int &scrollMode, int &direction) = 0;

 public slots:
	void setValue(double val);
	void fitValue(double val);
	void incValue(int steps);
	
 signals:
	void valueChanged(double value);
	void sliderPressed();
	void sliderReleased();
	void sliderMoved(double value);

 public:
	enum { ScrNone, ScrMouse, ScrTimer, ScrDirect, ScrPage };
	
	SliderBase( QWidget *parent = 0, const char *name = 0 );
	~SliderBase();

	void setUpdateTime(int t);
	//	void incValue(double nSteps);
	void stopMoving();
	void setTracking(bool enable);

      };

#endif
