//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: lcombo.cpp,v 1.1 2002/01/30 14:54:03 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "lcombo.h"

#include <qlayout.h>
#include <qframe.h>
#include <qlabel.h>

//---------------------------------------------------------
//   LabelCombo
//---------------------------------------------------------

LabelCombo::LabelCombo(const QString& txt, QWidget* parent,
   const char* name=0) : QWidget(parent, name)
      {
      setFixedHeight(20);
      QHBoxLayout* layout = new QHBoxLayout(this);
      QLabel* label = new QLabel(txt, this);
      box = new QComboBox(false, this);
      layout->addStretch();
      layout->addSpacing(5);
      layout->addWidget(label);
      layout->addSpacing(5);
      layout->addWidget(box);
      layout->addSpacing(5);
      layout->addStretch();
      connect(box, SIGNAL(activated(int)), SIGNAL(activated(int)));
      }

void LabelCombo::insertItem(const QString& txt, int index=-1)
      {
      box->insertItem(txt, index);
      }

