//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: filedialog.h,v 1.3 2001/12/04 09:36:18 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <qfiledialog.h>

class FileDialogButtons;

//---------------------------------------------------------
//   MFileDialog
//---------------------------------------------------------

class MFileDialog : public QFileDialog {
      FileDialogButtons* buttons;
      bool showButtons;
      QString baseDir;
      Q_OBJECT

   private slots:
      void globalToggled(bool);
      void userToggled(bool);
      void projectToggled(bool);

   public:
      MFileDialog(const QString& dir, const QString& filter = QString::null,
         QWidget* parent = 0, bool writeFlag = false);
      };

//---------------------------------------------------------
//   ContentsPreview
//---------------------------------------------------------

class ContentsPreview : public QWidget, public QFilePreview {
      virtual void previewUrl(const QUrl &url);
      QString path;
      QPixmap* bg;
   public:
      ContentsPreview(QWidget* parent, const char* name=0)
         : QWidget(parent, name) {
            bg = 0;
            }
      ~ContentsPreview();
      };

QString getSaveFileName(const QString& startWidth, const char** filter,
         QWidget* parent, const char* name=0);
QString getOpenFileName(const QString& startWidth, const char** filter,
         QWidget* parent, const char* name=0);
QString getImageFileName(const QString& startWith,
   const char** filters, QWidget* parent, const char* name=0);

FILE* fileOpen(QWidget*, QString, const QString&,
   const char*, bool&, bool = false, bool = false);


//---------------------------------------------------------
//   MFile
//    "Muse" File
//---------------------------------------------------------

class MFile {
      bool isPopen;
      FILE* f;
      QString path;
      QString ext;

   public:
      MFile(const QString& path, const QString& ext);
      ~MFile();
      FILE* open(const char* mode, const char** pattern,
         QWidget* parent, bool noError=false,
         bool warnIfOverwrite=false);
      };
