//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: waveedit.h,v 1.2 2001/11/20 15:19:34 muse Exp $
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#ifndef __WAVE_EDIT_H__
#define __WAVE_EDIT_H__

#include <qwidget.h>
#include "midieditor.h"

class QToolButton;
class PartList;
class WaveView;
class ScrollScale;
class QSlider;
class PosLabel;

//---------------------------------------------------------
//   WaveEdit
//---------------------------------------------------------

class WaveEdit : public MidiEditor {
      static QColor bg;

      WaveView* view;
      PartList* parts;
      QSlider* ymag;
      QToolBar* tools;
      QToolBar* tb1;
      QToolButton* solo;
      PosLabel* pos1;
      PosLabel* pos2;
      int partSn;

      Q_OBJECT
      virtual void closeEvent(QCloseEvent*);

   private slots:
      void cmd(int);
      void setTime(int t);

   signals:
      void deleted(int);

   public:
      WaveEdit(PartList*);
      ~WaveEdit();
      virtual void readStatus(Xml&);
      virtual void writeStatus(int, Xml&) const;
      static void readConfiguration(Xml&);
      static void writeConfiguration(int, Xml&);
      static QColor configBg()         { return bg; }
      static void setConfigBg(QColor _bg) { bg = _bg; }
      void setBg(QColor _bg);
      };

#endif

