//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: quant.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//  (C) Copyright 1999,2000 Werner Schweer (ws@seh.de)
//=========================================================

#include <stdio.h>
#include <qgroupbox.h>
#include <qscrollbar.h>
#include <qlayout.h>
#include "symbols.h"
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qtabwidget.h>
#include "score.h"
#include "quant.h"
#include "ncanvas.h"
#include "posedit.h"

//---------------------------------------------------------
//   showQuantDialog
//---------------------------------------------------------

bool ScoreCanvas::showQuantDialog(int* tick, int* nq, int* rq)
      {
      if (!quantConfig) {
            quantConfig = new QuantDialog(this, "quantConfig");
            }
      quantConfig->setTick(*tick);
      quantConfig->setNoteQuant(*nq);
      quantConfig->setRestQuant(*rq);
      if (quantConfig->exec()) {
            *nq = quantConfig->noteQuant();
            *rq = quantConfig->restQuant();
            *tick = quantConfig->tick();
            return true;
            }
      return false;
      }

//---------------------------------------------------------
//   quant2tick
//    >> from sconfig.c <<
//---------------------------------------------------------

static int quant2tick(int q)
      {
      int tab[] = {
            16, 32,  64, 128, 256,
            24, 48,  96, 192, 384
            };
      return tab[q];
      }
static int tick2quant(int tick)
      {
      switch(tick) {
            case 16:    return 0;
            case 32:    return 1;
            case 64:    return 2;
            case 128:   return 3;
            case 256:   return 4;
            case 24:    return 5;
            case 48:    return 6;
            case 96:    return 7;
            case 192:   return 8;
            case 384:   return 9;
            default:
                  printf("illeagal quant value\n");
                  break;
            }
      return 0;
      }


extern QComboBox* createQuantCombo(QWidget* parent);

//---------------------------------------------------------
//   QuantDialog
//---------------------------------------------------------

QuantDialog::QuantDialog(QWidget* parent, const char* name = 0)
   : QDialog(parent, name, true)
      {
      setCaption(tr("Display Quantize"));
      QGridLayout* grid = new QGridLayout(this, 1, 1, 0, -1, "grid");

      QWidget* w3 = new QGroupBox(2, Horizontal, 0, this, "w3");
      tl = new PosEdit(w3);
      new QLabel(tr("Position"), w3);
      quant1 = createQuantCombo(w3);
      new QLabel(tr("Note Quantize"), w3);
      quant2 = createQuantCombo(w3);
      new QLabel(tr("Rest Quantize"), w3);

      //---------------------------------------------------
      //    Cancel & Apply & OK Buttons
      //---------------------------------------------------

      QHBoxLayout* l4 = new QHBoxLayout(0, "l4");  // TODO: destroy
      QPushButton* b1 = new QPushButton(tr("Ok"), this, "b1");
      b1->setDefault(true);
      QPushButton* b3 = new QPushButton(tr("Cancel"), this, "b3");
      b1->setFixedWidth(80);
      b3->setFixedWidth(80);
      l4->addWidget(b1);
      l4->addSpacing(12);
      l4->addWidget(b3);
      l4->addStretch(1);
      connect(b1, SIGNAL(clicked()), SLOT(accept()));
      connect(b3, SIGNAL(clicked()), SLOT(reject()));

      grid->addWidget(w3, 0, 0);
      grid->addLayout(l4, 1, 0);
      }

int QuantDialog::noteQuant() const
      {
      return quant2tick(quant1->currentItem());
      }
int QuantDialog::restQuant() const
      {
      return quant2tick(quant2->currentItem());
      }
int QuantDialog::tick() const
      {
      return tl->pos().posTick();
      }
void QuantDialog::setTick(int v)
      {
      return tl->setValue(v);
      }
void QuantDialog::setNoteQuant(int val)
      {
      quant1->setCurrentItem(tick2quant(val));
      }
void QuantDialog::setRestQuant(int val)
      {
      quant2->setCurrentItem(tick2quant(val));
      }

