//=========================================================
//  MusE
//  Linux Music Editor
//  $Id: rack.cpp,v 1.1 2002/01/30 12:08:38 muse Exp $
//
//  (C) Copyright 2000 Werner Schweer (ws@seh.de)
//=========================================================

#include "rack.h"
#include "song.h"
#include <qtooltip.h>
#include <qpalette.h>
#include <qpainter.h>
#include "seq.h"
// #include "../ssource.h"
#include "../audiomix.h"
#include "../audiothread.h"

//---------------------------------------------------------
//   class RackSlot
//---------------------------------------------------------

class RackSlot : public QListBoxItem {
      bool _on;

      virtual void paint(QPainter*);
      virtual int height(const QListBox*) const { return 18; }

   public:
      RackSlot(QListBox* lb, const QString& s, bool bp);
      void setOn(bool f) {
            _on = f;
            listBox()->update();
            }
      void setName(const QString& s) {
            setText(s);
            }
      bool on() const { return _on; }
      };

//---------------------------------------------------------
//   RackSlot
//---------------------------------------------------------

RackSlot::RackSlot(QListBox* b, const QString& s, bool bp)
   : QListBoxItem(b)
      {
      if (s.isEmpty()) {
            setText("empty");
            _on = false;
            }
      else {
            setText(s);
            _on = bp;
            }
      }

//---------------------------------------------------------
//   paint
//---------------------------------------------------------

void RackSlot::paint(QPainter* painter)
      {
      painter->save();
      if (!_on) {
            const QColorGroup& g = listBox()->colorGroup();
            painter->fillRect(0,0,listBox()->width(),height(listBox()), g.dark());
            painter->setPen(g.light());
            }
      QFontMetrics fm = painter->fontMetrics();
      painter->drawText(3, fm.ascent() + fm.leading()/2, text());
      painter->restore();
      }

//---------------------------------------------------------
//   EffectRack
//---------------------------------------------------------

EffectRack::EffectRack(QWidget* parent, AudioNode* as, int n)
   : QListBox(parent)
      {
      src = as;
      channels = n;

      setHScrollBarMode(AlwaysOff);
      setVScrollBarMode(AlwaysOff);
      setSelectionMode(NoSelection);
      for (int i = 0; i < 4; ++i) {
            Pipeline* pipe = src->efxPipe();
            if (pipe) {
                  QString name  = pipe->name(i);
                  bool onflag   = pipe->isOn(i);
                  new RackSlot(this, name, onflag);
                  }
            }
      connect(this, SIGNAL(mouseButtonPressed(int, QListBoxItem*, const QPoint&)),
         this, SLOT(buttonPressed(int, QListBoxItem*, const QPoint&)));
      QToolTip::add(this, tr("effect rack"));
      }

//---------------------------------------------------------
//   minimumSizeHint
//---------------------------------------------------------

QSize EffectRack::minimumSizeHint() const
      {
      return QSize(10, 18*4);
      }

//---------------------------------------------------------
//   buttonPressed
//---------------------------------------------------------

void EffectRack::buttonPressed(int, QListBoxItem* it, const QPoint& pt)
      {
      if (it == 0)
            return;
      RackSlot* item = (RackSlot*)it;
      int idx = index(item);
      QString name;
      bool mute;
      Pipeline* pipe = src->efxPipe();
      if (pipe) {
            name  = pipe->name(idx);
            mute  = pipe->isOn(idx);
            }

      QPopupMenu* menu = new QPopupMenu;
      menu->insertItem("remove",   1, 1);
      menu->insertItem("bypass",   2, 2);
      menu->insertItem("show gui", 3, 3);

      menu->setItemChecked(2, !pipe->isOn(idx));
      menu->setItemChecked(3, pipe->guiVisible(idx));

      if (name.isEmpty()) {
            menu->insertItem("new", 0, 0);
            menu->setItemEnabled(1, false);
            menu->setItemEnabled(2, false);
            menu->setItemEnabled(3, false);
            }
      else
            menu->insertItem("change", 0, 0);

      int sel = menu->exec(pt, 1);
      delete menu;
      if (sel == -1)
            return;

      switch(sel) {
            case 0:     // new
                  {
                  Plugin* plugin = PluginDialog::getPlugin(this);
                  if (plugin) {
                        PluginI* plugi = new PluginI();
                        if (plugi->initPluginInstance(plugin, channels)) {
                              printf("cannot intantiate plugin <%s>\n",
                                 plugin->name().latin1());
                              delete plugi;
                              break;
                              }
                        item->setName(plugin->name());
                        item->setOn(true);
                        plugi->setOn(true);
                        audioThread->msgAddPlugin(src, idx, plugi);
                        }
                  break;
                  }
            case 1:     // remove
                  item->setName("empty");
                  item->setOn(false);
                  audioThread->msgAddPlugin(src, idx, 0);
                  break;
            case 2:     // on/off (bypass)
                  {
                  bool flag = !pipe->isOn(idx);
                  pipe->setOn(idx, flag);
                  item->setOn(flag);
                  break;
                  }
            case 3:     // show gui
                  {
                  bool flag = !pipe->guiVisible(idx);
                  pipe->showGui(idx, flag);
                  break;
                  }
            }
      }

